/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.man;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.helper.ManProvider;
import org.jboss.aesh.console.man.AeshFileDisplayer;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.console.man.parser.ManFileParser;
import org.jboss.aesh.util.ANSI;

@CommandDefinition(name="man", description="manuals")
public class Man
extends AeshFileDisplayer {
    @Arguments(completer=ManCompleter.class)
    private final List<String> manPages;
    private final ManFileParser fileParser;
    private static CommandRegistry registry;
    private final ManProvider manProvider;

    public Man(ManProvider manProvider) {
        this.manProvider = manProvider;
        this.manPages = new ArrayList<String>();
        this.fileParser = new ManFileParser();
    }

    public void setRegistry(CommandRegistry registry) {
        Man.registry = registry;
    }

    @Override
    public FileParser getFileParser() {
        return this.fileParser;
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.INVERT_BACKGROUND + "Pattern not found (press RETURN)" + "\u001b[0;39m");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH || this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(ANSI.INVERT_BACKGROUND);
            this.writeToConsole("Manual page " + this.fileParser.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + "\u001b[0;39m");
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.manPages == null || this.manPages.size() == 0) {
            commandInvocation.getShell().out().println("What manual page do you want?");
            return CommandResult.SUCCESS;
        }
        if (this.manPages.size() <= 0) {
            commandInvocation.getShell().out().println("No manual entry for " + this.manPages.get(0));
            return CommandResult.SUCCESS;
        }
        InputStream inputStream = this.manProvider.getManualDocument(this.manPages.get(0));
        if (inputStream != null) {
            this.setCommandInvocation(commandInvocation);
            try {
                this.fileParser.setInput(inputStream);
                this.afterAttach();
            }
            catch (IOException ex) {
                throw new CommandException(ex);
            }
        }
        return CommandResult.SUCCESS;
    }

    public static class ManCompleter
    implements OptionCompleter {
        public void complete(CompleterInvocation completerData) {
            ArrayList<String> completeValues = new ArrayList<String>();
            if (registry != null) {
                for (String command : registry.getAllCommandNames()) {
                    if (!command.startsWith(completerData.getGivenCompleteValue())) continue;
                    completeValues.add(command);
                }
                completerData.setCompleterValues(completeValues);
            }
        }
    }
}

