/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.keycloak.client.registration.cli.common.EndpointType;
import org.keycloak.util.JsonSerialization;

public class HttpUtil {
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String UTF_8 = "utf-8";
    private static HttpClient httpClient;
    private static SSLConnectionSocketFactory sslsf;

    public static InputStream doGet(String url, String acceptType, String authorization) {
        try {
            HttpGet request = new HttpGet(url);
            request.setHeader("Accept", acceptType);
            return HttpUtil.doRequest(authorization, request);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static InputStream doPost(String url, String contentType, String acceptType, String content, String authorization) {
        try {
            return HttpUtil.doPostOrPut(contentType, acceptType, content, authorization, new HttpPost(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static InputStream doPut(String url, String contentType, String acceptType, String content, String authorization) {
        try {
            return HttpUtil.doPostOrPut(contentType, acceptType, content, authorization, new HttpPut(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    public static void doDelete(String url, String authorization) {
        try {
            HttpDelete request = new HttpDelete(url);
            HttpUtil.doRequest(authorization, request);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request - " + e.getMessage(), e);
        }
    }

    private static InputStream doPostOrPut(String contentType, String acceptType, String content, String authorization, HttpEntityEnclosingRequestBase request) throws IOException {
        request.setHeader("Content-Type", contentType);
        request.setHeader("Accept", acceptType);
        if (content != null) {
            request.setEntity(new StringEntity(content));
        }
        return HttpUtil.doRequest(authorization, request);
    }

    private static InputStream doRequest(String authorization, HttpRequestBase request) throws IOException {
        int code;
        HttpUtil.addAuth(request, authorization);
        HttpResponse response = HttpUtil.getHttpClient().execute(request);
        InputStream responseStream = null;
        if (response.getEntity() != null) {
            responseStream = response.getEntity().getContent();
        }
        if ((code = response.getStatusLine().getStatusCode()) >= 200 && code < 300) {
            return responseStream;
        }
        Map error = null;
        try {
            Header header = response.getEntity().getContentType();
            if (header != null && APPLICATION_JSON.equals(header.getValue())) {
                error = JsonSerialization.readValue(responseStream, Map.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read error response - " + e.getMessage(), e);
        }
        finally {
            responseStream.close();
        }
        String message = null;
        if (error != null) {
            message = (String)error.get("error_description") + " [" + (String)error.get("error") + "]";
        }
        throw new RuntimeException(message != null ? message : response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
    }

    private static void addAuth(HttpRequestBase request, String authorization) {
        if (authorization != null) {
            request.setHeader("Authorization", authorization);
        }
    }

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = sslsf != null ? HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory(sslsf).build() : HttpClientBuilder.create().useSystemProperties().build();
        }
        return httpClient;
    }

    public static String getExpectedContentType(EndpointType type) {
        switch (type) {
            case DEFAULT: 
            case OIDC: {
                return APPLICATION_JSON;
            }
            case SAML2: {
                return APPLICATION_XML;
            }
        }
        throw new RuntimeException("Unsupported endpoint type: " + (Object)((Object)type));
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to urlencode", e);
        }
    }

    public static void setTruststore(File file, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        if (!file.isFile()) {
            throw new RuntimeException("Truststore file not found: " + file.getAbsolutePath());
        }
        SSLContext theContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(file, password == null ? null : password.toCharArray()).build();
        sslsf = new SSLConnectionSocketFactory(theContext);
    }
}

