/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Permission {
    @JsonProperty(value="resource_set_id")
    private String resourceSetId;
    @JsonProperty(value="resource_set_name")
    private final String resourceSetName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Set<String>> claims;

    public Permission() {
        this(null, null, null, null);
    }

    public Permission(String resourceSetId, String resourceSetName, Set<String> scopes, Map<String, Set<String>> claims) {
        this.resourceSetId = resourceSetId;
        this.resourceSetName = resourceSetName;
        this.scopes = scopes;
        this.claims = claims;
    }

    public String getResourceSetId() {
        return this.resourceSetId;
    }

    public String getResourceSetName() {
        return this.resourceSetName;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        return this.scopes;
    }

    public Map<String, Set<String>> getClaims() {
        return this.claims;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Permission {").append("id=").append(this.resourceSetId).append(", name=").append(this.resourceSetName).append(", scopes=").append(this.scopes).append("}");
        return builder.toString();
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }
}

