/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.keycloak.Config;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class DefaultJpaConnectionProviderFactory
implements JpaConnectionProviderFactory {
    private volatile EntityManagerFactory emf;
    private Config.Scope config;

    public JpaConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        EntityManager em = this.emf.createEntityManager();
        em = PersistenceExceptionConverter.create(em);
        session.getTransaction().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        return new DefaultJpaConnectionProvider(em);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.emf == null) {
            DefaultJpaConnectionProviderFactory defaultJpaConnectionProviderFactory = this;
            synchronized (defaultJpaConnectionProviderFactory) {
                if (this.emf == null) {
                    String unitName = this.config.get("unitName");
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    if (unitName == null) {
                        unitName = "keycloak-default";
                        String dataSource = this.config.get("dataSource");
                        if (dataSource != null) {
                            if (this.config.getBoolean("jta", Boolean.valueOf(false)).booleanValue()) {
                                properties.put("javax.persistence.jtaDataSource", dataSource);
                            } else {
                                properties.put("javax.persistence.nonJtaDataSource", dataSource);
                            }
                        } else {
                            String password;
                            String user;
                            properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                            properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                            String driverDialect = this.config.get("driverDialect");
                            if (driverDialect != null && driverDialect.length() > 0) {
                                properties.put("hibernate.dialect", driverDialect);
                            }
                            if ((user = this.config.get("user")) != null) {
                                properties.put("javax.persistence.jdbc.user", user);
                            }
                            if ((password = this.config.get("password")) != null) {
                                properties.put("javax.persistence.jdbc.password", password);
                            }
                        }
                        String databaseSchema = this.config.get("databaseSchema", "validate");
                        if (databaseSchema != null) {
                            properties.put("hibernate.hbm2ddl.auto", databaseSchema);
                        }
                        properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                        properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                    }
                    this.emf = Persistence.createEntityManagerFactory((String)unitName, properties);
                }
            }
        }
    }
}

