/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class DefaultJpaConnectionProviderFactory
implements JpaConnectionProviderFactory,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultJpaConnectionProviderFactory.class);
    private volatile EntityManagerFactory emf;
    private Config.Scope config;
    private Map<String, String> operationalInfo;

    public JpaConnectionProvider create(KeycloakSession session) {
        this.lazyInit(session);
        EntityManager em = this.emf.createEntityManager();
        em = PersistenceExceptionConverter.create(em);
        session.getTransaction().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        return new DefaultJpaConnectionProvider(em);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.emf == null) {
            DefaultJpaConnectionProviderFactory defaultJpaConnectionProviderFactory = this;
            synchronized (defaultJpaConnectionProviderFactory) {
                if (this.emf == null) {
                    String schema;
                    logger.debug((Object)"Initializing JPA connections");
                    Connection connection = null;
                    String databaseSchema = this.config.get("databaseSchema");
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String unitName = "keycloak-default";
                    String dataSource = this.config.get("dataSource");
                    if (dataSource != null) {
                        if (this.config.getBoolean("jta", Boolean.valueOf(false)).booleanValue()) {
                            properties.put("javax.persistence.jtaDataSource", dataSource);
                        } else {
                            properties.put("javax.persistence.nonJtaDataSource", dataSource);
                        }
                    } else {
                        String password;
                        properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                        properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                        String user = this.config.get("user");
                        if (user != null) {
                            properties.put("javax.persistence.jdbc.user", user);
                        }
                        if ((password = this.config.get("password")) != null) {
                            properties.put("javax.persistence.jdbc.password", password);
                        }
                    }
                    String driverDialect = this.config.get("driverDialect");
                    if (driverDialect != null && driverDialect.length() > 0) {
                        properties.put("hibernate.dialect", driverDialect);
                    }
                    if ((schema = this.config.get("schema")) != null) {
                        properties.put("hibernate.default_schema", schema);
                    }
                    if (databaseSchema != null) {
                        if (databaseSchema.equals("development-update")) {
                            properties.put("hibernate.hbm2ddl.auto", "update");
                            databaseSchema = null;
                        } else if (databaseSchema.equals("development-validate")) {
                            properties.put("hibernate.hbm2ddl.auto", "validate");
                            databaseSchema = null;
                        }
                    }
                    properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                    properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                    connection = this.getConnection();
                    try {
                        this.prepareOperationalInfo(connection);
                        if (databaseSchema != null) {
                            logger.trace((Object)"Updating database");
                            JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
                            if (updater == null) {
                                throw new RuntimeException("Can't update database: JPA updater provider not found");
                            }
                            if (databaseSchema.equals("update")) {
                                String currentVersion = null;
                                try {
                                    ResultSet resultSet = connection.createStatement().executeQuery(updater.getCurrentVersionSql(schema));
                                    if (resultSet.next()) {
                                        currentVersion = resultSet.getString(1);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                if (currentVersion == null || !"1.8.0".equals(currentVersion)) {
                                    updater.update(session, connection, schema);
                                } else {
                                    logger.debug((Object)"Database is up to date");
                                }
                            } else if (databaseSchema.equals("validate")) {
                                updater.validate(connection, schema);
                            } else {
                                throw new RuntimeException("Invalid value for databaseSchema: " + databaseSchema);
                            }
                            logger.trace((Object)"Database update completed");
                        }
                        logger.trace((Object)"Creating EntityManagerFactory");
                        this.emf = Persistence.createEntityManagerFactory((String)unitName, properties);
                        logger.trace((Object)"EntityManagerFactory created");
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                logger.warn((Object)e);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void prepareOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(this.config.get("url"), this.config.get("user"), this.config.get("password"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }
}

