/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.truststore;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.keycloak.connections.truststore.HostnameVerificationPolicy;
import org.keycloak.connections.truststore.TruststoreProvider;
import org.keycloak.connections.truststore.TruststoreProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class JSSETruststoreConfigurator {
    private TruststoreProvider provider;
    private volatile SSLSocketFactory sslFactory;
    private volatile TrustManager[] tm;

    public JSSETruststoreConfigurator(KeycloakSession session) {
        KeycloakSessionFactory factory = session.getKeycloakSessionFactory();
        TruststoreProviderFactory truststoreFactory = (TruststoreProviderFactory)factory.getProviderFactory(TruststoreProvider.class, "file");
        this.provider = (TruststoreProvider)truststoreFactory.create(session);
        if (this.provider != null && this.provider.getTruststore() == null) {
            this.provider = null;
        }
    }

    public JSSETruststoreConfigurator(TruststoreProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSSLSocketFactory() {
        if (this.provider == null) {
            return null;
        }
        if (this.sslFactory == null) {
            JSSETruststoreConfigurator jSSETruststoreConfigurator = this;
            synchronized (jSSETruststoreConfigurator) {
                if (this.sslFactory == null) {
                    try {
                        SSLContext sslctx = SSLContext.getInstance("TLS");
                        sslctx.init(null, this.getTrustManagers(), null);
                        this.sslFactory = sslctx.getSocketFactory();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize SSLContext: ", e);
                    }
                }
            }
        }
        return this.sslFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustManager[] getTrustManagers() {
        if (this.provider == null) {
            return null;
        }
        if (this.tm == null) {
            JSSETruststoreConfigurator jSSETruststoreConfigurator = this;
            synchronized (jSSETruststoreConfigurator) {
                if (this.tm == null) {
                    TrustManagerFactory tmf = null;
                    try {
                        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(this.provider.getTruststore());
                        this.tm = tmf.getTrustManagers();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize TrustManager: ", e);
                    }
                }
            }
        }
        return this.tm;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.provider == null) {
            return null;
        }
        HostnameVerificationPolicy policy = this.provider.getPolicy();
        switch (policy) {
            case ANY: {
                return new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                };
            }
            case WILDCARD: {
                return new BrowserCompatHostnameVerifier();
            }
            case STRICT: {
                return new StrictHostnameVerifier();
            }
        }
        throw new IllegalStateException("Unknown policy: " + policy.name());
    }

    public TruststoreProvider getProvider() {
        return this.provider;
    }
}

