/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.io.IOException;
import java.security.PublicKey;
import org.jboss.resteasy.jose.jws.JWSInput;
import org.jboss.resteasy.jose.jws.crypto.RSAProvider;
import org.jboss.resteasy.jwt.JsonSerialization;
import org.keycloak.ResourceMetadata;
import org.keycloak.VerificationException;
import org.keycloak.representations.SkeletonKeyToken;

public class RSATokenVerifier {
    public static SkeletonKeyToken verifyToken(String tokenString, ResourceMetadata metadata) throws VerificationException {
        PublicKey realmKey = metadata.getRealmKey();
        String realm = metadata.getRealm();
        return RSATokenVerifier.verifyToken(tokenString, realmKey, realm);
    }

    public static SkeletonKeyToken verifyToken(String tokenString, PublicKey realmKey, String realm) throws VerificationException {
        JWSInput input = new JWSInput(tokenString);
        boolean verified = false;
        try {
            verified = RSAProvider.verify((JWSInput)input, (PublicKey)realmKey);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (!verified) {
            throw new VerificationException("Token signature not validated");
        }
        SkeletonKeyToken token = null;
        try {
            token = (SkeletonKeyToken)((Object)JsonSerialization.fromBytes(SkeletonKeyToken.class, (byte[])input.getContent()));
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
        if (!token.isActive()) {
            throw new VerificationException("Token is not active.");
        }
        String user = token.getPrincipal();
        if (user == null) {
            throw new VerificationException("Token user was null");
        }
        if (!realm.equals(token.getAudience())) {
            throw new VerificationException("Token audience doesn't match domain");
        }
        return token;
    }
}

