/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.AbstractOAuthClient;

public class JaxrsOAuthClient
extends AbstractOAuthClient {
    protected static final Logger logger = Logger.getLogger(JaxrsOAuthClient.class);

    public Response redirect(UriInfo uriInfo, String redirectUri) {
        return this.redirect(uriInfo, redirectUri, null);
    }

    public Response redirect(UriInfo uriInfo, String redirectUri, String path) {
        String state = this.getStateCode();
        if (path != null) {
            state = state + "#" + path;
        }
        URI url = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).build(new Object[0]);
        NewCookie cookie = new NewCookie(this.getStateCookieName(), state, this.getStateCookiePath(uriInfo), null, null, -1, this.isSecure, true);
        logger.debug("NewCookie: " + cookie.toString());
        logger.debug("Oauth Redirect to: " + url);
        return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
    }

    public String getStateCookiePath(UriInfo uriInfo) {
        if (this.stateCookiePath != null) {
            return this.stateCookiePath;
        }
        return uriInfo.getBaseUri().getPath();
    }

    public String getBearerToken(UriInfo uriInfo, HttpHeaders headers) throws BadRequestException, InternalServerErrorException {
        String error = this.getError(uriInfo);
        if (error != null) {
            throw new BadRequestException((Throwable)new Exception("OAuth error: " + error));
        }
        this.checkStateCookie(uriInfo, headers);
        String code = this.getAccessCode(uriInfo);
        if (code == null) {
            throw new BadRequestException((Throwable)new Exception("code parameter was null"));
        }
        return this.resolveBearerToken(uriInfo.getRequestUri().toString(), code);
    }

    public String getError(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"error");
    }

    public String getAccessCode(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"code");
    }

    public String checkStateCookie(UriInfo uriInfo, HttpHeaders headers) {
        Cookie stateCookie = (Cookie)headers.getCookies().get(this.stateCookieName);
        if (stateCookie == null) {
            throw new BadRequestException("state cookie not set");
        }
        String state = (String)uriInfo.getQueryParameters().getFirst((Object)"state");
        if (state == null) {
            throw new BadRequestException("state parameter was null");
        }
        if (!state.equals(stateCookie.getValue())) {
            throw new BadRequestException("state parameter invalid");
        }
        if (state.indexOf(35) != -1) {
            return state.substring(state.indexOf(35) + 1);
        }
        return null;
    }
}

