/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.keycloak.representations.JsonWebToken;

public class SkeletonKeyToken
extends JsonWebToken {
    @JsonProperty(value="issuedFor")
    public String issuedFor;
    @JsonProperty(value="trusted-certs")
    protected Set<String> trustedCertificates;
    @JsonProperty(value="allowed-origins")
    protected Set<String> allowedOrigins;
    @JsonProperty(value="realm_access")
    protected Access realmAccess;
    @JsonProperty(value="resource_access")
    protected Map<String, Access> resourceAccess = new HashMap<String, Access>();

    public Map<String, Access> getResourceAccess() {
        return this.resourceAccess;
    }

    @JsonIgnore
    public boolean isVerifyCaller() {
        if (this.getRealmAccess() != null && this.getRealmAccess().getVerifyCaller() != null) {
            return this.getRealmAccess().getVerifyCaller();
        }
        return false;
    }

    @JsonIgnore
    public boolean isVerifyCaller(String resource) {
        Access access = this.getResourceAccess(resource);
        if (access != null && access.getVerifyCaller() != null) {
            return access.getVerifyCaller();
        }
        return false;
    }

    @JsonIgnore
    public Access getResourceAccess(String resource) {
        return this.resourceAccess.get(resource);
    }

    public Access addAccess(String service) {
        Access token = new Access();
        this.resourceAccess.put(service, token);
        return token;
    }

    @Override
    public SkeletonKeyToken id(String id) {
        return (SkeletonKeyToken)super.id(id);
    }

    @Override
    public SkeletonKeyToken expiration(long expiration) {
        return (SkeletonKeyToken)super.expiration(expiration);
    }

    @Override
    public SkeletonKeyToken notBefore(long notBefore) {
        return (SkeletonKeyToken)super.notBefore(notBefore);
    }

    @Override
    public SkeletonKeyToken issuedAt(long issuedAt) {
        return (SkeletonKeyToken)super.issuedAt(issuedAt);
    }

    @Override
    public SkeletonKeyToken issuer(String issuer) {
        return (SkeletonKeyToken)super.issuer(issuer);
    }

    @Override
    public SkeletonKeyToken audience(String audience) {
        return (SkeletonKeyToken)super.audience(audience);
    }

    @Override
    public SkeletonKeyToken principal(String principal) {
        return (SkeletonKeyToken)super.principal(principal);
    }

    @Override
    public SkeletonKeyToken type(String type) {
        return (SkeletonKeyToken)super.type(type);
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public Access getRealmAccess() {
        return this.realmAccess;
    }

    public void setRealmAccess(Access realmAccess) {
        this.realmAccess = realmAccess;
    }

    public Set<String> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public void setTrustedCertificates(Set<String> trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
    }

    public String getIssuedFor() {
        return this.issuedFor;
    }

    public SkeletonKeyToken issuedFor(String issuedFor) {
        this.issuedFor = issuedFor;
        return this;
    }

    public static class Access {
        @JsonProperty(value="roles")
        protected Set<String> roles;
        @JsonProperty(value="verify_caller")
        protected Boolean verifyCaller;

        public Set<String> getRoles() {
            return this.roles;
        }

        public Access roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        @JsonIgnore
        public boolean isUserInRole(String role) {
            if (this.roles == null) {
                return false;
            }
            return this.roles.contains(role);
        }

        public Access addRole(String role) {
            if (this.roles == null) {
                this.roles = new HashSet<String>();
            }
            this.roles.add(role);
            return this;
        }

        public Boolean getVerifyCaller() {
            return this.verifyCaller;
        }

        public Access verifyCaller(Boolean required) {
            this.verifyCaller = required;
            return this;
        }
    }
}

