/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.util.Iterator;
import java.util.ServiceLoader;

public class ProviderLoader<T>
implements Iterable<T> {
    private ServiceLoader<T> serviceLoader;

    public static <T> Iterable<T> load(Class<T> service) {
        ServiceLoader<T> providers = ServiceLoader.load(service);
        return new ProviderLoader<T>(providers);
    }

    private ProviderLoader(ServiceLoader<T> serviceLoader) {
        this.serviceLoader = serviceLoader;
    }

    @Override
    public Iterator iterator() {
        return new ProviderIterator(this.serviceLoader.iterator());
    }

    private static class ProviderIterator<T>
    implements Iterator<T> {
        private Iterator<T> itr;
        private T next;

        private ProviderIterator(Iterator<T> itr) {
            this.itr = itr;
            this.setNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T n = this.next;
            this.setNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void setNext() {
            this.next = null;
            while (this.itr.hasNext()) {
                if (!this.itr.hasNext()) continue;
                T n = this.itr.next();
                if (System.getProperties().containsKey(n.getClass().getName() + ".disabled")) continue;
                this.next = n;
                return;
            }
        }
    }
}

