/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.util.Base64Url;
import org.keycloak.util.JsonSerialization;

public class JWSInput {
    String wireString;
    String encodedHeader;
    String encodedContent;
    String encodedSignature;
    JWSHeader header;
    byte[] content;
    byte[] signature;

    public JWSInput(String wire) {
        this.wireString = wire;
        String[] parts = wire.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Parsing error");
        }
        this.encodedHeader = parts[0];
        this.encodedContent = parts[1];
        try {
            this.content = Base64Url.decode(this.encodedContent);
            if (parts.length > 2) {
                this.encodedSignature = parts[2];
                this.signature = Base64Url.decode(this.encodedSignature);
            }
            byte[] headerBytes = Base64Url.decode(this.encodedHeader);
            this.header = JsonSerialization.readValue(headerBytes, JWSHeader.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getWireString() {
        return this.wireString;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public String getEncodedContent() {
        return this.encodedContent;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public <T> T readJsonContent(Class<T> type) throws IOException {
        return JsonSerialization.readValue(this.content, type);
    }

    public String readContentAsString() {
        try {
            return new String(this.content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

