/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.nio.charset.StandardCharsets;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;

public class BasicAuthHelper {
    public static String createHeader(String username, String password) {
        return "Basic " + Base64.encodeBytes((byte[])(username + ':' + password).getBytes(StandardCharsets.UTF_8));
    }

    public static abstract class UrlEncoded {
        public static String createHeader(String username, String password) {
            return "Basic " + Base64Url.encode((byte[])(username + ':' + password).getBytes(StandardCharsets.UTF_8));
        }

        public static String[] parseHeader(String header) {
            if (header.length() < 6) {
                return null;
            }
            String type = header.substring(0, 5);
            if (!(type = type.toLowerCase()).equalsIgnoreCase("Basic")) {
                return null;
            }
            String val = new String(Base64Url.decode((String)header.substring(6)));
            int seperatorIndex = val.indexOf(":");
            if (seperatorIndex == -1) {
                return null;
            }
            String user = val.substring(0, seperatorIndex);
            String pw = val.substring(seperatorIndex + 1);
            return new String[]{user, pw};
        }
    }
}

