/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.util.JsonSerialization;

public class SkeletonKeyTokenTest {
    @Test
    public void testToken() throws Exception {
        AccessToken token = this.createSimpleToken();
        String json = JsonSerialization.writeValueAsString((Object)token);
        token = (AccessToken)JsonSerialization.readValue((String)json, AccessToken.class);
        Assert.assertEquals((Object)"111", (Object)token.getId());
        AccessToken.Access foo = token.getResourceAccess("foo");
        Assert.assertNotNull((Object)foo);
        Assert.assertTrue((boolean)foo.isUserInRole("admin"));
    }

    @Test
    public void testRSA() throws Exception {
        AccessToken token = this.createSimpleToken();
        token.id("111");
        token.addAccess("foo").addRole("admin");
        token.addAccess("bar").addRole("user");
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        String encoded = new JWSBuilder().jsonContent((Object)token).rsa256(keyPair.getPrivate());
        JWSInput input = new JWSInput(encoded);
        token = (AccessToken)input.readJsonContent(AccessToken.class);
        Assert.assertEquals((Object)"111", (Object)token.getId());
        Assert.assertTrue((boolean)RSAProvider.verify((JWSInput)input, (PublicKey)keyPair.getPublic()));
    }

    @Test
    public void testSerialization() throws Exception {
        AccessToken token = this.createSimpleToken();
        IDToken idToken = new IDToken();
        idToken.setEmail("joe@email.cz");
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        String encoded = new JWSBuilder().jsonContent((Object)token).rsa256(keyPair.getPrivate());
        String encodedIdToken = new JWSBuilder().jsonContent((Object)idToken).rsa256(keyPair.getPrivate());
        KeycloakSecurityContext ctx = new KeycloakSecurityContext(encoded, token, encodedIdToken, idToken);
        KeycloakPrincipal principal = new KeycloakPrincipal("joe", ctx);
        ByteArrayOutputStream bso = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bso);
        oos.writeObject(principal);
        oos.close();
        byte[] bytes = bso.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        principal = (KeycloakPrincipal)ois.readObject();
        ctx = principal.getKeycloakSecurityContext();
        token = ctx.getToken();
        idToken = ctx.getIdToken();
        System.out.println("Size of serialized principal: " + bytes.length);
        Assert.assertEquals((Object)encoded, (Object)ctx.getTokenString());
        Assert.assertEquals((Object)encodedIdToken, (Object)ctx.getIdTokenString());
        Assert.assertEquals((Object)"111", (Object)token.getId());
        Assert.assertEquals((Object)"111", (Object)token.getId());
        Assert.assertTrue((boolean)token.getResourceAccess("foo").isUserInRole("admin"));
        Assert.assertTrue((boolean)token.getResourceAccess("bar").isUserInRole("user"));
        Assert.assertEquals((Object)"joe@email.cz", (Object)idToken.getEmail());
        Assert.assertEquals((Object)"acme", (Object)ctx.getRealm());
        ois.close();
    }

    @Test
    public void testTokenWithoutResourceAccess() throws Exception {
        AccessToken token = new AccessToken();
        token.id("111");
        token.issuer("http://localhost:8080/auth/acme");
        String json = JsonSerialization.writeValueAsString((Object)token);
        Assert.assertFalse((boolean)json.contains("realm_access"));
        Assert.assertFalse((boolean)json.contains("resource_access"));
        token = (AccessToken)JsonSerialization.readValue((String)json, AccessToken.class);
        Assert.assertNull((Object)token.getRealmAccess());
        Assert.assertTrue((token.getResourceAccess() != null && token.getResourceAccess().isEmpty() ? 1 : 0) != 0);
        Assert.assertNull((Object)token.getResourceAccess("foo"));
    }

    private AccessToken createSimpleToken() {
        AccessToken token = new AccessToken();
        token.id("111");
        token.issuer("http://localhost:8080/auth/acme");
        token.addAccess("foo").addRole("admin");
        token.addAccess("bar").addRole("user");
        return token;
    }

    @Test
    public void testZipException() throws Exception {
        String logoutAction = "eyJhbGciOiJSUzI1NiJ9.eyJpZCI6ImUwYmRmMjQyLWJjZGItNGVjMy1hMGU4LTNjN2YyOTUzOTk5MC0xNDU1NzgyNTU2NjAyIiwiZXhwaXJhdGlvbiI6MTQ1NTc4MjU4NiwicmVzb3VyY2UiOiJwcm9kdWN0LXBvcnRhbCIsImFjdGlvbiI6IkxPR09VVCIsImFkYXB0ZXJTZXNzaW9uSWRzIjpbImx2c0oxNUpSX01XUE13aTIwbWRhTkJFRVZQZzQtMTkzVUZKem42M1EiXSwibm90QmVmb3JlIjowLCJrZXljbG9ha1Nlc3Npb25JZHMiOlsiOThkNWE3YTYtYjNmNi00ZTg3LWI5OTktOTg1N2YzMDRiZjY4Il19.H4vo7YXW8oQgYsIo9VPYeSsp1jXJR0TwJUwmiXjQJSyxFoKhHgIh3Y63ldVUeBRppxX9xhjOdYEckeppAn-1XnNxUmbExXWXirRIw8tiEtUPPCPztdkKsM0y6xWRd3Sjgg4fWB_1sMn6EWvCAvO7ahs6Rbb2Vo18nlHfxYRSTWw";
        JWSInput input = new JWSInput(logoutAction);
    }
}

