/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.json.StringListMapDeserializer;

public class StringListMapDeserializerTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
    }

    @After
    public void tearDown() {
        this.mapper = null;
    }

    @Test
    public void nonNullValue() throws IOException {
        Map<String, List<String>> attributes = this.deserialize("\"foo\": \"bar\"");
        TestCase.assertTrue((boolean)attributes.containsKey("foo"));
        List<String> foo = attributes.get("foo");
        Assert.assertEquals((long)1L, (long)foo.size());
        Assert.assertEquals((Object)"bar", (Object)foo.get(0));
    }

    @Test
    public void nonNullValueArray() throws IOException {
        Map<String, List<String>> attributes = this.deserialize("\"foo\": [ \"bar\", \"baz\" ]");
        TestCase.assertTrue((boolean)attributes.containsKey("foo"));
        List<String> foo = attributes.get("foo");
        Assert.assertEquals((long)2L, (long)foo.size());
        Assert.assertEquals((Object)"baz", (Object)foo.get(1));
    }

    @Test
    public void nullValue() throws IOException {
        Map<String, List<String>> attributes = this.deserialize("\"foo\": null");
        TestCase.assertTrue((boolean)attributes.containsKey("foo"));
        List<String> foo = attributes.get("foo");
        Assert.assertEquals((long)1L, (long)foo.size());
        Assert.assertNull((Object)foo.get(0));
    }

    @Test
    public void nullValueArray() throws IOException {
        Map<String, List<String>> attributes = this.deserialize("\"foo\": [ null, \"something\", null ]");
        TestCase.assertTrue((boolean)attributes.containsKey("foo"));
        List<String> foo = attributes.get("foo");
        Assert.assertEquals((long)3L, (long)foo.size());
        Assert.assertEquals((Object)"something", (Object)foo.get(1));
        Assert.assertNull((Object)foo.get(2));
    }

    private Map<String, List<String>> deserialize(String attributeKeyValueString) throws IOException {
        TestObject testObject = (TestObject)this.mapper.readValue("{ \"attributes\": {" + attributeKeyValueString + " } }", TestObject.class);
        return testObject.getAttributes();
    }

    private static class TestObject {
        @JsonDeserialize(using=StringListMapDeserializer.class)
        private final Map<String, List<String>> attributes = null;

        private TestObject() {
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }
    }
}

