/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose;

import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.rule.CryptoInitRule;

public abstract class HmacTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void testHmacSignatures() throws Exception {
        SecretKeySpec secret = new SecretKeySpec(UUID.randomUUID().toString().getBytes(), "HmacSHA256");
        String encoded = new JWSBuilder().content("12345678901234567890".getBytes()).hmac256((SecretKey)secret);
        System.out.println("length: " + encoded.length());
        JWSInput input = new JWSInput(encoded);
        Assert.assertTrue((boolean)HMACProvider.verify((JWSInput)input, (SecretKey)secret));
    }
}

