/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.util.Map;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

public abstract class JWKSUtilsTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void publicRs256() throws Exception {
        String kidRsa1 = "key1";
        String kidRsa2 = "key2";
        String kidInvalidKey = "ignored";
        String kidEC1 = "key3";
        String kidEC2 = "key4";
        String jwksJson = "{\"keys\": [  {   \"kty\": \"RSA\",   \"alg\": \"RS256\",   \"use\": \"sig\",   \"kid\": \"" + kidRsa1 + "\",   \"n\": \"soFDjoZ5mQ8XAA7reQAFg90inKAHk0DXMTizo4JuOsgzUbhcplIeZ7ks83hsEjm8mP8lUVaHMPMAHEIp3gu6Xxsg-s73ofx1dtt_Fo7aj8j383MFQGl8-FvixTVobNeGeC0XBBQjN8lEl-lIwOa4ZoERNAShplTej0ntDp7TQm0=\",   \"e\": \"AQAB\"  }  ,{   \"kty\": \"RSA\",   \"use\": \"sig\",   \"kid\": \"" + kidRsa2 + "\",   \"n\": \"soFDjoZ5mQ8XAA7reQAFg90inKAHk0DXMTizo4JuOsgzUbhcplIeZ7ks83hsEjm8mP8lUVaHMPMAHEIp3gu6Xxsg-s73ofx1dtt_Fo7aj8j383MFQGl8-FvixTVobNeGeC0XBBQjN8lEl-lIwOa4ZoERNAShplTej0ntDp7TQm0=\",   \"e\": \"AQAB\"  },  {   \"kty\": \"RSA\",   \"kid\": \"" + kidInvalidKey + "\",   \"n\": \"soFDjoZ5mQ8XAA7reQAFg90inKAHk0DXMTizo4JuOsgzUbhcplIeZ7ks83hsEjm8mP8lUVaHMPMAHEIp3gu6Xxsg-s73ofx1dtt_Fo7aj8j383MFQGl8-FvixTVobNeGeC0XBBQjN8lEl-lIwOa4ZoERNAShplTej0ntDp7TQm0=\",   \"e\": \"AQAB\"  },  {   \"kty\": \"EC\",   \"use\": \"sig\",   \"crv\": \"P-384\",   \"kid\": \"" + kidEC1 + "\",   \"x\": \"KVZ5h_W0-8fXmUrxmyRpO_9vwwI7urXfyxGdxm1hpEuhPj2hhDxivnb2BhNvtC6O\",   \"y\": \"1J3JVw_zR3uB3biAE7fs3V_4tJy2M1JinzWj9a4je5GSoW6zgGV4bk85OcuyUAhj\",   \"alg\": \"ES384\"  },  {   \"kty\": \"EC\",   \"use\": \"sig\",   \"crv\": \"P-384\",   \"kid\": \"" + kidEC2 + "\",   \"x\": \"KVZ5h_W0-8fXmUrxmyRpO_9vwwI7urXfyxGdxm1hpEuhPj2hhDxivnb2BhNvtC6O\",   \"y\": \"1J3JVw_zR3uB3biAE7fs3V_4tJy2M1JinzWj9a4je5GSoW6zgGV4bk85OcuyUAhj\"  }] }";
        JSONWebKeySet jsonWebKeySet = (JSONWebKeySet)JsonSerialization.readValue((String)jwksJson, JSONWebKeySet.class);
        Map keyWrappersForUse = JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jsonWebKeySet, (JWK.Use)JWK.Use.SIG);
        Assert.assertEquals((long)4L, (long)keyWrappersForUse.size());
        KeyWrapper key = (KeyWrapper)keyWrappersForUse.get(kidRsa1);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"RS256", (Object)key.getAlgorithmOrDefault());
        Assert.assertEquals((Object)KeyUse.SIG, (Object)key.getUse());
        Assert.assertEquals((Object)kidRsa1, (Object)key.getKid());
        Assert.assertEquals((Object)"RSA", (Object)key.getType());
        key = (KeyWrapper)keyWrappersForUse.get(kidRsa2);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"RS256", (Object)key.getAlgorithmOrDefault());
        Assert.assertEquals((Object)KeyUse.SIG, (Object)key.getUse());
        Assert.assertEquals((Object)kidRsa2, (Object)key.getKid());
        Assert.assertEquals((Object)"RSA", (Object)key.getType());
        key = (KeyWrapper)keyWrappersForUse.get(kidEC1);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"ES384", (Object)key.getAlgorithmOrDefault());
        Assert.assertEquals((Object)KeyUse.SIG, (Object)key.getUse());
        Assert.assertEquals((Object)kidEC1, (Object)key.getKid());
        Assert.assertEquals((Object)"EC", (Object)key.getType());
        key = (KeyWrapper)keyWrappersForUse.get(kidEC2);
        Assert.assertNotNull((Object)key);
        Assert.assertNull((Object)key.getAlgorithmOrDefault());
        Assert.assertEquals((Object)KeyUse.SIG, (Object)key.getUse());
        Assert.assertEquals((Object)kidEC2, (Object)key.getKid());
        Assert.assertEquals((Object)"EC", (Object)key.getType());
    }
}

