/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.util.BasicAuthHelper;

public class BasicAuthHelperTest {
    @Test
    public void createHeader() {
        String username = "Aladdin";
        String password = "open sesame";
        String actual = BasicAuthHelper.createHeader((String)username, (String)password);
        String expect = "Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==";
        Assert.assertEquals((Object)expect, (Object)actual);
    }

    @Test
    public void parseHeader() {
        String username = "Aladdin";
        String password = "open sesame";
        String header = BasicAuthHelper.createHeader((String)username, (String)password);
        Object[] actual = BasicAuthHelper.parseHeader((String)header);
        Assert.assertArrayEquals((Object[])new String[]{username, password}, (Object[])actual);
    }

    @Test
    public void rfc6749_createHeader() {
        String username = "user";
        String password = "secret/with=special?character";
        String actual = BasicAuthHelper.RFC6749.createHeader((String)username, (String)password);
        String expect = "Basic dXNlcjpzZWNyZXQlMkZ3aXRoJTNEc3BlY2lhbCUzRmNoYXJhY3Rlcg==";
        Assert.assertEquals((Object)expect, (Object)actual);
    }

    @Test
    public void rfc6749_parseHeader() {
        String username = "user";
        String password = "secret/with=special?character";
        String header = BasicAuthHelper.createHeader((String)username, (String)password);
        Object[] actual = BasicAuthHelper.parseHeader((String)header);
        Assert.assertArrayEquals((Object[])new String[]{username, password}, (Object[])actual);
    }
}

