/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.RSATokenVerifier;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.AccessToken;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.util.JsonSerialization;

public abstract class RSAVerifierTest {
    private static KeyPair idpPair;
    private static KeyPair badPair;
    private AccessToken token;
    @ClassRule
    public static CryptoInitRule cryptoInitRule;

    @BeforeClass
    public static void setupCerts() throws Exception {
        badPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        idpPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }

    @Before
    public void initTest() {
        this.token = new AccessToken();
        this.token.type("Bearer").subject("CN=Client").issuer("http://localhost:8080/auth/realm").addAccess("service").addRole("admin");
    }

    @Test
    public void testSimpleVerification() throws Exception {
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        System.out.print("encoded size: " + encoded.length());
        AccessToken token = this.verifySkeletonKeyToken(encoded);
        Assert.assertTrue((boolean)token.getResourceAccess("service").getRoles().contains("admin"));
        Assert.assertEquals((Object)"CN=Client", (Object)token.getSubject());
    }

    private AccessToken verifySkeletonKeyToken(String encoded) throws VerificationException {
        return RSATokenVerifier.verifyToken((String)encoded, (PublicKey)idpPair.getPublic(), (String)"http://localhost:8080/auth/realm");
    }

    public void testSpeed() throws Exception {
        byte[] tokenBytes = JsonSerialization.writeValueAsBytes((Object)this.token);
        long start = System.currentTimeMillis();
        int count = 50000;
        for (int i = 0; i < count; ++i) {
            String encoded = new JWSBuilder().content(tokenBytes).rsa256(idpPair.getPrivate());
            this.verifySkeletonKeyToken(encoded);
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("took: " + end);
    }

    @Test
    public void testBadSignature() {
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(badPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testNotBeforeGood() throws Exception {
        this.token.notBefore(Time.currentTime() - 100);
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        v = this.verifySkeletonKeyToken(encoded);
    }

    @Test
    public void testNotBeforeBad() {
        this.token.notBefore(Time.currentTime() + 100);
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    @Test
    public void testExpirationGood() throws Exception {
        this.token.expiration(Time.currentTime() + 100);
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        v = this.verifySkeletonKeyToken(encoded);
    }

    @Test
    public void testExpirationBad() {
        this.token.expiration(Time.currentTime() - 100);
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testTokenAuth() {
        this.token = new AccessToken();
        this.token.subject("CN=Client").issuer("http://localhost:8080/auth/realms/demo").addAccess("service").addRole("admin").verifyCaller(Boolean.valueOf(true));
        this.token.setEmail("bill@jboss.org");
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        System.out.println("token size: " + encoded.length());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testAudience() throws Exception {
        this.token.addAudience("my-app");
        this.token.addAudience("your-app");
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        this.verifyAudience(encoded, "my-app");
        this.verifyAudience(encoded, "your-app");
        try {
            this.verifyAudience(encoded, "other-app");
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
        try {
            this.verifyAudience(encoded, null);
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void verifyAudience(String encodedToken, String expectedAudience) throws VerificationException {
        TokenVerifier.create((String)encodedToken, AccessToken.class).publicKey(idpPair.getPublic()).realmUrl("http://localhost:8080/auth/realm").audience(new String[]{expectedAudience}).verify();
    }

    static {
        cryptoInitRule = new CryptoInitRule();
    }
}

