/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.x509;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.UserIdentityExtractor;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.keycloak.common.util.PemUtils;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.rule.CryptoInitRule;

public abstract class CertificateIdentityExtractorTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void testExtractsCertInPemFormat() throws Exception {
        X509Certificate x509Certificate = this.getCertificate();
        String certificatePem = PemUtils.encodeCertificate((Certificate)x509Certificate);
        UserIdentityExtractor extractor = CryptoIntegration.getProvider().getIdentityExtractorProvider().getCertificatePemIdentityExtractor();
        String userIdentity = (String)extractor.extractUserIdentity(new X509Certificate[]{x509Certificate});
        Assert.assertEquals((Object)certificatePem, (Object)userIdentity);
    }

    @Test
    public void testExtractsCertInSubjectDNFormat() throws Exception {
        X509Certificate x509Certificate = this.getCertificate();
        UserIdentityExtractor extractor = CryptoIntegration.getProvider().getIdentityExtractorProvider().getX500NameExtractor("CN", certs -> certs[0].getSubjectX500Principal());
        String userIdentity = (String)extractor.extractUserIdentity(new X509Certificate[]{x509Certificate});
        Assert.assertEquals((Object)"Test User", (Object)userIdentity);
    }

    @Test
    public void testX509SubjectAltName_otherName() throws Exception {
        UserIdentityExtractorProvider.SubjectAltNameExtractor extractor = CryptoIntegration.getProvider().getIdentityExtractorProvider().getSubjectAltNameExtractor(0);
        X509Certificate cert = this.getCertificate();
        Object upn = extractor.extractUserIdentity(new X509Certificate[]{cert});
        Assert.assertEquals((Object)"test-user@some-company-domain", (Object)upn);
    }

    @Test
    public void testX509SubjectAltName_email() throws Exception {
        UserIdentityExtractorProvider.SubjectAltNameExtractor extractor = CryptoIntegration.getProvider().getIdentityExtractorProvider().getSubjectAltNameExtractor(1);
        X509Certificate cert = this.getCertificate();
        Object upn = extractor.extractUserIdentity(new X509Certificate[]{cert});
        Assert.assertEquals((Object)"test@somecompany.com", (Object)upn);
    }

    private X509Certificate getCertificate() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/certs/UPN-cert.pem");
        String s = StreamUtil.readString((InputStream)is, (Charset)Charset.defaultCharset());
        return PemUtils.decodeCertificate((String)s);
    }
}

