/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose;

import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.rule.CryptoInitRule;

public abstract class HmacTest {
    private final Logger logger = Logger.getLogger((String)this.getClass().getName());
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void testHmacSignaturesWithRandomSecretKey() throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(UUID.randomUUID().toString().getBytes(), "HmacSHA256");
        this.testHMACSignAndVerify(secretKey, "testHmacSignaturesWithRandomSecretKey");
    }

    @Test
    public void testHmacSignaturesWithShortSecretKey() throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec("secret".getBytes(), "HmacSHA256");
        this.testHMACSignAndVerify(secretKey, "testHmacSignaturesWithShortSecretKey");
    }

    protected void testHMACSignAndVerify(SecretKey secretKey, String test) throws Exception {
        String encoded = new JWSBuilder().content("12345678901234567890".getBytes()).hmac256(secretKey);
        this.logger.infof("%s: Length of encoded content: %d, Length of secret key: %d", (Object)test, (Object)encoded.length(), (Object)secretKey.getEncoded().length);
        JWSInput input = new JWSInput(encoded);
        Assert.assertTrue((boolean)HMACProvider.verify((JWSInput)input, (SecretKey)secretKey));
    }
}

