/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose;

import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.util.JsonSerialization;

public class JsonWebTokenTest {
    @Test
    public void testAudSingle() throws IOException {
        String single = "{ \"aud\": \"test\" }";
        JsonWebToken s = (JsonWebToken)JsonSerialization.readValue((String)single, JsonWebToken.class);
        Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])s.getAudience());
    }

    @Test
    public void testAudArray() throws IOException {
        String single = "{ \"aud\": [\"test\"] }";
        JsonWebToken s = (JsonWebToken)JsonSerialization.readValue((String)single, JsonWebToken.class);
        Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])s.getAudience());
    }

    @Test
    public void testAddAudience() {
        JsonWebToken s = new JsonWebToken();
        s.addAudience("audience-1");
        Assert.assertArrayEquals((Object[])new String[]{"audience-1"}, (Object[])s.getAudience());
        s.addAudience("audience-2");
        Assert.assertArrayEquals((Object[])new String[]{"audience-1", "audience-2"}, (Object[])s.getAudience());
        s.addAudience("audience-3");
        Assert.assertArrayEquals((Object[])new String[]{"audience-1", "audience-2", "audience-3"}, (Object[])s.getAudience());
        s.addAudience("audience-2");
        Assert.assertArrayEquals((Object[])new String[]{"audience-1", "audience-2", "audience-3"}, (Object[])s.getAudience());
    }

    @Test
    public void test() throws IOException {
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.audience(new String[]{"test"});
        Assert.assertTrue((boolean)JsonSerialization.writeValueAsPrettyString((Object)jsonWebToken).contains("\"aud\" : \"test\""));
    }

    @Test
    public void testArray() throws IOException {
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.audience(new String[]{"test", "test2"});
        Assert.assertTrue((boolean)JsonSerialization.writeValueAsPrettyString((Object)jsonWebToken).contains("\"aud\" : [ \"test\", \"test2\" ]"));
    }

    @Test
    public void isActiveReturnFalseWhenBeforeTimeInFuture() {
        int currentTime = Time.currentTime();
        int futureTime = currentTime + 10;
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.notBefore(futureTime);
        TestCase.assertFalse((boolean)jsonWebToken.isActive());
    }

    @Test
    public void isActiveReturnTrueWhenBeforeTimeInPast() {
        int currentTime = Time.currentTime();
        int pastTime = currentTime - 10;
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.notBefore(pastTime);
        Assert.assertTrue((boolean)jsonWebToken.isActive());
    }

    @Test
    public void isActiveShouldReturnTrueWhenBeforeTimeInFutureWithinTimeSkew() {
        int notBeforeTime = Time.currentTime() + 5;
        int allowedClockSkew = 10;
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.notBefore(notBeforeTime);
        Assert.assertTrue((boolean)jsonWebToken.isActive(allowedClockSkew));
    }

    @Test
    public void isActiveShouldReturnFalseWhenWhenBeforeTimeInFutureOutsideTimeSkew() {
        int notBeforeTime = Time.currentTime() + 10;
        int allowedClockSkew = 5;
        JsonWebToken jsonWebToken = new JsonWebToken();
        jsonWebToken.notBefore(notBeforeTime);
        TestCase.assertFalse((boolean)jsonWebToken.isActive(allowedClockSkew));
    }
}

