/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.JWEUtils;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.AesCbcHmacShaJWEEncryptionProvider;
import org.keycloak.jose.jwe.enc.AesGcmJWEEncryptionProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.rule.CryptoInitRule;

public abstract class JWETest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    protected static final String PAYLOAD = "Hello world! How are you man? I hope you are fine. This is some quite a long text, which is much longer than just simple 'Hello World'";
    protected static final byte[] HMAC_SHA256_KEY = new byte[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 13, 14, 15, 16};
    protected static final byte[] AES_128_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    protected static final byte[] HMAC_SHA512_KEY = new byte[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 13, 14, 15, 16, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    protected static final byte[] AES_256_KEY = new byte[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 13, 14, 15, 16, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    @Test
    public void testDirect_Aes128CbcHmacSha256() throws Exception {
        SecretKeySpec aesKey = new SecretKeySpec(AES_128_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA256_KEY, "HMACSHA2");
        this.testDirectEncryptAndDecrypt(aesKey, hmacKey, "A128CBC-HS256", PAYLOAD, true);
    }

    @Ignore
    @Test
    public void testDirect_Aes256CbcHmacSha512() throws Exception {
        SecretKeySpec aesKey = new SecretKeySpec(AES_256_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA512_KEY, "HMACSHA2");
        this.testDirectEncryptAndDecrypt(aesKey, hmacKey, "A256CBC-HS512", PAYLOAD, true);
    }

    protected void testDirectEncryptAndDecrypt(Key aesKey, Key hmacKey, String encAlgorithm, String payload, boolean sysout) throws Exception {
        JWEHeader jweHeader = new JWEHeader("dir", encAlgorithm, null);
        JWE jwe = new JWE().header(jweHeader).content(payload.getBytes(StandardCharsets.UTF_8));
        jwe.getKeyStorage().setCEKKey(aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey(hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        String encodedContent = jwe.encodeJwe();
        if (sysout) {
            System.out.println("Encoded content: " + encodedContent);
            System.out.println("Encoded content length: " + encodedContent.length());
        }
        jwe = new JWE();
        jwe.getKeyStorage().setCEKKey(aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey(hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        jwe.verifyAndDecodeJwe(encodedContent);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)payload, (Object)decodedContent);
    }

    @Ignore
    @Test
    public void testPerfDirect() throws Exception {
        int iterations = 50000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            SecretKeySpec aesKey = new SecretKeySpec(AES_128_KEY, "AES");
            SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA256_KEY, "HMACSHA2");
            String encAlg = "A128CBC-HS256";
            String payload = PAYLOAD + i;
            this.testDirectEncryptAndDecrypt(aesKey, hmacKey, encAlg, payload, false);
        }
        long took = System.currentTimeMillis() - start;
        System.out.println("Iterations: " + iterations + ", took: " + took);
    }

    @Test
    public void testAesKW_Aes128CbcHmacSha256() throws Exception {
        SecretKeySpec aesKey = new SecretKeySpec(AES_128_KEY, "AES");
        this.testAesKW_Aes128CbcHmacSha256(aesKey);
    }

    private void testAesKW_Aes128CbcHmacSha256(SecretKey aesKey) throws JWEException {
        JWEHeader jweHeader = new JWEHeader("A128KW", "A128CBC-HS256", null);
        JWE jwe = new JWE().header(jweHeader).content(PAYLOAD.getBytes(StandardCharsets.UTF_8));
        jwe.getKeyStorage().setEncryptionKey((Key)aesKey);
        String encodedContent = jwe.encodeJwe();
        System.out.println("Encoded content: " + encodedContent);
        System.out.println("Encoded content length: " + encodedContent.length());
        jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)aesKey);
        jwe.verifyAndDecodeJwe(encodedContent);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)PAYLOAD, (Object)decodedContent);
    }

    @Test
    public void testSalt() {
        byte[] random = JWEUtils.generateSecret((int)8);
        System.out.print("new byte[] = {");
        for (byte b : random) {
            System.out.print("" + Byte.toString(b) + ",");
        }
    }

    @Test
    public void externalJweAes128CbcHmacSha256Test() throws JWEException {
        String externalJwe = "eyJlbmMiOiJBMTI4Q0JDLUhTMjU2IiwiYWxnIjoiZGlyIn0..qysUrI1iVtiG4Z4jyr7XXg.apdNSQhR7WDMg6IHf5aLVI0gGp6JuOHYmIUtflns4WHmyxOOnh_GShLI6DWaK_SiywTV5gZvZYtl8H8Iv5fTfLkc4tiDDjbdtmsOP7tqyRxVh069gU5UvEAgmCXbIKALutgYXcYe2WM4E6BIHPTSt8jXdkktFcm7XHiD7mpakZyjXsG8p3XVkQJ72WbJI_t6.Ks6gHeko7BRTZ4CFs5ijRA";
        System.out.println("External encoded content length: " + externalJwe.length());
        SecretKeySpec aesKey = new SecretKeySpec(AES_128_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA256_KEY, "HMACSHA2");
        JWE jwe = new JWE();
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        jwe.verifyAndDecodeJwe(externalJwe);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)PAYLOAD, (Object)decodedContent);
    }

    @Ignore
    @Test
    public void externalJweAes256CbcHmacSha512Test() throws JWEException {
        String externalJwe = "eyJlbmMiOiJBMjU2Q0JDLUhTNTEyIiwiYWxnIjoiZGlyIn0..xUPndQ5U69CYaWMKr4nyeg.AzSzba6OdNsvTIoNpub8d2TmYnkY7W8Sd-1S33DjJwJsSaNcfvfXBq5bqXAGVAnLHrLZJKWoEYsmOrYHz3Nao-kpLtUpc4XZI8yiYUqkHTjmxZnfD02R6hz31a5KBCnDTtUEv23VSxm8yUyQKoUTpVHbJ3b2VQvycg2XFUXPsA6oaSSEpz-uwe1Vmun2hUBB.Qal4rMYn1RrXQ9AQ9ONUjUXvlS2ow8np-T8QWMBR0ns";
        System.out.println("External encoded content length: " + externalJwe.length());
        SecretKeySpec aesKey = new SecretKeySpec(AES_256_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA512_KEY, "HMACSHA2");
        JWE jwe = new JWE();
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        jwe.verifyAndDecodeJwe(externalJwe);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)PAYLOAD, (Object)decodedContent);
    }

    @Test
    public void externalJweAes128KeyWrapTest() throws Exception {
        String externalJwe = "eyJhbGciOiJBMTI4S1ciLCJlbmMiOiJBMTI4Q0JDLUhTMjU2In0.6KB707dM9YTIgHtLvtgWQ8mKwboJW3of9locizkDTHzBC2IlrT1oOQ.AxY8DCtDaGlsbGljb3RoZQ.KDlTtXchhZTGufMYmOYGS4HffxPSUrfmqCHXaI9wOGY.U0m_YmjN04DJvceFICbCVQ";
        byte[] aesKey = Base64Url.decode((String)"GawgguFyGrWKav7AX4VKUg");
        SecretKeySpec aesKeySpec = new SecretKeySpec(aesKey, "AES");
        JWE jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)aesKeySpec);
        jwe.verifyAndDecodeJwe(externalJwe);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"Live long and prosper.", (Object)decodedContent);
    }

    @Test
    public void testRSA1_5_A128GCM() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesGcm("RSA1_5", "A128GCM");
    }

    @Test
    public void testRSAOAEP_A128GCM() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesGcm("RSA-OAEP", "A128GCM");
    }

    @Test
    public void testRSAOAEP256_A128GCM() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesGcm("RSA-OAEP-256", "A128GCM");
    }

    @Test
    public void testRSA1_5_A128CBCHS256() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesHmacSha("RSA1_5", "A128CBC-HS256");
    }

    @Test
    public void testRSAOAEP_A128CBCHS256() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesHmacSha("RSA-OAEP", "A128CBC-HS256");
    }

    @Test
    public void testRSAOAEP256_A128CBCHS256() throws Exception {
        this.testKeyEncryption_ContentEncryptionAesHmacSha("RSA-OAEP-256", "A128CBC-HS256");
    }

    private void testKeyEncryption_ContentEncryptionAesGcm(String jweAlgorithmName, String jweEncryptionName) throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        JWEAlgorithmProvider jweAlgorithmProvider = (JWEAlgorithmProvider)CryptoIntegration.getProvider().getAlgorithmProvider(JWEAlgorithmProvider.class, jweAlgorithmName);
        AesGcmJWEEncryptionProvider jweEncryptionProvider = new AesGcmJWEEncryptionProvider(jweEncryptionName);
        JWEHeader jweHeader = new JWEHeader(jweAlgorithmName, jweEncryptionName, null);
        JWE jwe = new JWE().header(jweHeader).content(PAYLOAD.getBytes(StandardCharsets.UTF_8));
        jwe.getKeyStorage().setEncryptionKey((Key)keyPair.getPublic());
        String encodedContent = jwe.encodeJwe(jweAlgorithmProvider, (JWEEncryptionProvider)jweEncryptionProvider);
        System.out.println("Encoded content: " + encodedContent);
        System.out.println("Encoded content length: " + encodedContent.length());
        jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)keyPair.getPrivate());
        jwe.verifyAndDecodeJwe(encodedContent, jweAlgorithmProvider, (JWEEncryptionProvider)jweEncryptionProvider);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        System.out.println("Decoded content: " + decodedContent);
        System.out.println("Decoded content length: " + decodedContent.length());
        Assert.assertEquals((Object)PAYLOAD, (Object)decodedContent);
    }

    private void testKeyEncryption_ContentEncryptionAesHmacSha(String jweAlgorithmName, String jweEncryptionName) throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        SecretKeySpec aesKey = new SecretKeySpec(AES_128_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(HMAC_SHA256_KEY, "HMACSHA2");
        JWEAlgorithmProvider jweAlgorithmProvider = (JWEAlgorithmProvider)CryptoIntegration.getProvider().getAlgorithmProvider(JWEAlgorithmProvider.class, jweAlgorithmName);
        AesCbcHmacShaJWEEncryptionProvider jweEncryptionProvider = new AesCbcHmacShaJWEEncryptionProvider(jweEncryptionName);
        JWEHeader jweHeader = new JWEHeader(jweAlgorithmName, jweEncryptionName, null);
        JWE jwe = new JWE().header(jweHeader).content(PAYLOAD.getBytes(StandardCharsets.UTF_8));
        jwe.getKeyStorage().setEncryptionKey((Key)keyPair.getPublic());
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        String encodedContent = jwe.encodeJwe(jweAlgorithmProvider, (JWEEncryptionProvider)jweEncryptionProvider);
        System.out.println("Encoded content: " + encodedContent);
        System.out.println("Encoded content length: " + encodedContent.length());
        jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)keyPair.getPrivate());
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        jwe.verifyAndDecodeJwe(encodedContent, jweAlgorithmProvider, (JWEEncryptionProvider)jweEncryptionProvider);
        String decodedContent = new String(jwe.getContent(), StandardCharsets.UTF_8);
        System.out.println("Decoded content: " + decodedContent);
        System.out.println("Decoded content length: " + decodedContent.length());
        Assert.assertEquals((Object)PAYLOAD, (Object)decodedContent);
    }
}

