/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.jose.jws.crypto.HashUtils;

public class AtHashTest {
    @Test
    public void testAtHashRsa() {
        this.verifyHash("RS256", "jHkWEdUXMU1BwAsC4vtUsZwnNvTIxEl0z9K3vx5KF0Y", "77QmUPtjPfzWtF2AnpK9RQ");
        this.verifyHash("RS256", "ya29.eQETFbFOkAs8nWHcmYXKwEi0Zz46NfsrUU_KuQLOLTwWS40y6Fb99aVzEXC0U14m61lcPMIr1hEIBA", "aUAkJG-u6x4RTWuILWy-CA");
    }

    @Test
    public void testAtHashEs() {
        this.verifyHash("ES256", "jHkWEdUXMU1BwAsC4vtUsZwnNvTIxEl0z9K3vx5KF0Y", "77QmUPtjPfzWtF2AnpK9RQ");
        this.verifyHash("ES256", "ya29.eQETFbFOkAs8nWHcmYXKwEi0Zz46NfsrUU_KuQLOLTwWS40y6Fb99aVzEXC0U14m61lcPMIr1hEIBA", "aUAkJG-u6x4RTWuILWy-CA");
    }

    private void verifyHash(String jwtAlgorithm, String accessToken, String expectedAtHash) {
        String atHash = HashUtils.accessTokenHash((String)jwtAlgorithm, (String)accessToken);
        Assert.assertEquals((Object)expectedAtHash, (Object)atHash);
    }
}

