/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestUtils;

public class ArrayElementDisclosureTest {
    @Test
    public void testSdJwtWithUndiclosedArrayElements6_1() {
        JsonNode claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-holder-claims.json");
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("email", "JnwGqRFZjMprsoZobherdQ").withUndisclosedClaim("phone_number", "ffZ03jm_zeHyG4-yoNt6vg").withUndisclosedClaim("address", "INhOGJnu82BAtsOwiCJc_A").withUndisclosedClaim("birthdate", "d0l3jsh5sBzj2oEhZxrJGw").withUndisclosedArrayElt("nationalities", Integer.valueOf(1), "nPuoQnkRFq3BIeAm7AnXFA").build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(claimSet).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-issuer-payload-udisclosed-array-ellement.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }

    @Test
    public void testSdJwtWithUndiclosedAndDecoyArrayElements6_1() {
        JsonNode claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-holder-claims.json");
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("email", "JnwGqRFZjMprsoZobherdQ").withUndisclosedClaim("phone_number", "ffZ03jm_zeHyG4-yoNt6vg").withUndisclosedClaim("address", "INhOGJnu82BAtsOwiCJc_A").withUndisclosedClaim("birthdate", "d0l3jsh5sBzj2oEhZxrJGw").withUndisclosedArrayElt("nationalities", Integer.valueOf(0), "Qg_O64zqAxe412a108iroA").withUndisclosedArrayElt("nationalities", Integer.valueOf(1), "nPuoQnkRFq3BIeAm7AnXFA").withDecoyArrayElt("nationalities", Integer.valueOf(1), "5bPs1IquZNa0hkaFzzzZNw").build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(claimSet).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-issuer-payload-decoy-array-ellement.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }
}

