/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.sdjwt.AbstractSdJwtClaim;
import org.keycloak.sdjwt.DecoyArrayElement;
import org.keycloak.sdjwt.SdJwtArrayElement;
import org.keycloak.sdjwt.SdJwtClaimName;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.UndisclosedArrayElement;
import org.keycloak.sdjwt.VisibleArrayElement;

public class ArrayDisclosure
extends AbstractSdJwtClaim {
    private final List<SdJwtArrayElement> elements;
    private JsonNode visibleClaimValue = null;
    private final List<DecoyArrayElement> decoyElements;

    private ArrayDisclosure(SdJwtClaimName claimName, List<SdJwtArrayElement> elements, List<DecoyArrayElement> decoyElements) {
        super(claimName);
        this.elements = elements;
        this.decoyElements = decoyElements;
    }

    @Override
    public JsonNode getVisibleClaimValue(String hashAlgo) {
        if (this.visibleClaimValue != null) {
            return this.visibleClaimValue;
        }
        ArrayList visibleElts = new ArrayList();
        this.elements.stream().filter(Objects::nonNull).forEach(e -> visibleElts.add(e.getVisibleValue(hashAlgo)));
        this.decoyElements.stream().filter(Objects::nonNull).forEach(e -> {
            if (e.getIndex() < visibleElts.size()) {
                visibleElts.add(e.getIndex(), e.getVisibleValue(hashAlgo));
            } else {
                visibleElts.add(e.getVisibleValue(hashAlgo));
            }
        });
        ArrayNode n = SdJwtUtils.mapper.createArrayNode();
        visibleElts.forEach(arg_0 -> ((ArrayNode)n).add(arg_0));
        this.visibleClaimValue = n;
        return this.visibleClaimValue;
    }

    @Override
    public List<String> getDisclosureStrings() {
        ArrayList<String> disclosureStrings = new ArrayList<String>();
        this.elements.stream().filter(Objects::nonNull).forEach(e -> {
            String disclosureString = e.getDisclosureString();
            if (disclosureString != null) {
                disclosureStrings.add(disclosureString);
            }
        });
        return disclosureStrings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SdJwtClaimName claimName;
        private final List<SdJwtArrayElement> elements = new ArrayList<SdJwtArrayElement>();
        private final List<DecoyArrayElement> decoyElements = new ArrayList<DecoyArrayElement>();

        public Builder withClaimName(String claimName) {
            this.claimName = new SdJwtClaimName(claimName);
            return this;
        }

        public Builder withVisibleElement(JsonNode elementValue) {
            this.elements.add(new VisibleArrayElement(elementValue));
            return this;
        }

        public Builder withUndisclosedElement(SdJwtSalt salt, JsonNode elementValue) {
            SdJwtSalt sdJwtSalt = salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : salt;
            this.elements.add(UndisclosedArrayElement.builder().withSalt(sdJwtSalt).withArrayElement(elementValue).build());
            return this;
        }

        public void withDecoyElt(Integer position, SdJwtSalt salt) {
            SdJwtSalt sdJwtSalt = salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : salt;
            DecoyArrayElement decoyElement = DecoyArrayElement.builder().withSalt(sdJwtSalt).atIndex(position).build();
            this.decoyElements.add(decoyElement);
        }

        public ArrayDisclosure build() {
            return new ArrayDisclosure(this.claimName, Collections.unmodifiableList(this.elements), Collections.unmodifiableList(this.decoyElements));
        }
    }
}

