/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.sdjwt.SdJwtUtils;

public class JsonClaimsetTest {
    @Test
    public void testRead61ClaimSet() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("sdjwt/s6.1-holder-claims.json");
        JsonNode claimSet = SdJwtUtils.mapper.readTree(is);
        String expected_sub_claim = "user_42";
        JsonNode sub_claim = claimSet.get("sub");
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)sub_claim.getNodeType());
        Assert.assertEquals((Object)expected_sub_claim, (Object)sub_claim.asText());
        JsonNode phone_number_verified_claim = claimSet.get("phone_number_verified");
        Boolean expected_phone_number_verified_claim = true;
        Assert.assertEquals((Object)JsonNodeType.BOOLEAN, (Object)phone_number_verified_claim.getNodeType());
        Assert.assertEquals((Object)expected_phone_number_verified_claim, (Object)phone_number_verified_claim.asBoolean());
        JsonNode address_claim = claimSet.get("address");
        Assert.assertEquals((Object)JsonNodeType.OBJECT, (Object)address_claim.getNodeType());
        JsonNode street_address_claim = address_claim.get("street_address");
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)street_address_claim.getNodeType());
        String expected_street_address_claim = "123 Main St";
        Assert.assertEquals((Object)expected_street_address_claim, (Object)street_address_claim.asText());
        JsonNode updated_at_claim = claimSet.get("updated_at");
        int expected_updated_at_claim = 1570000000;
        Assert.assertEquals((Object)JsonNodeType.NUMBER, (Object)updated_at_claim.getNodeType());
        Assert.assertEquals((long)expected_updated_at_claim, (long)updated_at_claim.asInt());
        JsonNode nationalities_claim = claimSet.get("nationalities");
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)nationalities_claim.getNodeType());
        Assert.assertEquals((long)2L, (long)nationalities_claim.size());
        JsonNode element_0_nationalities_claim = nationalities_claim.get(0);
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)element_0_nationalities_claim.getNodeType());
        String expected_element_0_nationalities_claim = "US";
        Assert.assertEquals((Object)expected_element_0_nationalities_claim, (Object)element_0_nationalities_claim.asText());
        JsonNode element_1_nationalities_claim = nationalities_claim.get(1);
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)element_1_nationalities_claim.getNodeType());
        String expected_element_1_nationalities_claim = "DE";
        Assert.assertEquals((Object)expected_element_1_nationalities_claim, (Object)element_1_nationalities_claim.asText());
    }
}

