/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.sdjwtvp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestSettings;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.sdjwtvp.TestCompareSdJwt;
import org.keycloak.sdjwt.vp.KeyBindingJWT;
import org.keycloak.sdjwt.vp.SdJwtVP;

public abstract class SdJwtVPTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void testIssuerSignedJWTWithUndiclosedClaims3_3() {
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("family_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("email", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("phone_number", "eI8ZWm9QnKPpNPeNenHdhQ").withUndisclosedClaim("address", "Qg_O64zqAxe412a108iroA").withUndisclosedClaim("birthdate", "AJx-095VPrpTtN4QMOqROA").withUndisclosedClaim("is_over_18", "Pc33JM2LchcU_lHggv_ufQ").withUndisclosedClaim("is_over_21", "G02NSrQfjFXQ7Io09syajA").withUndisclosedClaim("is_over_65", "lklxF5jMYlGTPUovMNIvCA").build();
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).withSigner(TestSettings.getInstance().getIssuerSignerContext()).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
        String sdJwtString = sdJwt.toSdJwtString();
        SdJwtVP actualSdJwt = SdJwtVP.of((String)sdJwtString);
        String expectedString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s3.3-unsecured-sd-jwt.txt");
        SdJwtVP expecteSdJwt = SdJwtVP.of((String)expectedString);
        TestCompareSdJwt.compare(expecteSdJwt, actualSdJwt);
    }

    @Test
    public void testIssuerSignedJWTWithUndiclosedClaims6_1() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s6.1-issued-payload.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        Assert.assertEquals((long)0L, (long)sdJwtVP.getRecursiveDigests().size());
        Assert.assertEquals((long)0L, (long)sdJwtVP.getGhostDigests().size());
    }

    @Test
    public void testA1_Example2_with_nested_disclosure_and_decoy_claims() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/a1.example2-sdjwt.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        Assert.assertEquals((long)10L, (long)sdJwtVP.getDisclosures().size());
        Assert.assertEquals((long)0L, (long)sdJwtVP.getRecursiveDigests().size());
        Assert.assertEquals((long)0L, (long)sdJwtVP.getGhostDigests().size());
    }

    @Test
    public void testS7_3_RecursiveDisclosureOfStructuredSdJwt() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s7.3-sdjwt.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        Assert.assertEquals((long)5L, (long)sdJwtVP.getDisclosures().size());
        Assert.assertEquals((long)4L, (long)sdJwtVP.getRecursiveDigests().size());
        Assert.assertEquals((long)0L, (long)sdJwtVP.getGhostDigests().size());
    }

    @Test
    public void testS7_3_GhostDisclosures() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s7.3-sdjwt+ghost.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        Assert.assertEquals((long)8L, (long)sdJwtVP.getDisclosures().size());
        Assert.assertEquals((long)4L, (long)sdJwtVP.getRecursiveDigests().size());
        Assert.assertEquals((long)3L, (long)sdJwtVP.getGhostDigests().size());
    }

    @Test
    public void testS7_3_VerifyIssuerSignaturePositive() throws VerificationException {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s7.3-sdjwt.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        sdJwtVP.getIssuerSignedJWT().verifySignature(TestSettings.getInstance().getIssuerVerifierContext());
    }

    @Test(expected=VerificationException.class)
    public void testS7_3_VerifyIssuerSignatureNegative() throws VerificationException {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s7.3-sdjwt.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        sdJwtVP.getIssuerSignedJWT().verifySignature(TestSettings.getInstance().getHolderVerifierContext());
    }

    @Test
    public void testS6_2_PresentationPositive() throws VerificationException {
        String jwsType = "vc+sd-jwt";
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s6.2-presented-sdjwtvp.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        JsonNode keyBindingClaims = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.2-key-binding-claims.json");
        String presentation = sdJwtVP.present(null, keyBindingClaims, TestSettings.getInstance().getHolderSignerContext(), jwsType);
        SdJwtVP presenteSdJwtVP = SdJwtVP.of((String)presentation);
        Assert.assertTrue((boolean)presenteSdJwtVP.getKeyBindingJWT().isPresent());
        ((KeyBindingJWT)presenteSdJwtVP.getKeyBindingJWT().get()).verifySignature(TestSettings.getInstance().getHolderVerifierContext());
        ((KeyBindingJWT)presenteSdJwtVP.getKeyBindingJWT().get()).verifySignature(TestSettings.verifierContextFrom(presenteSdJwtVP.getCnfClaim(), "ES256"));
    }

    @Test(expected=VerificationException.class)
    public void testS6_2_PresentationNegative() throws VerificationException {
        String jwsType = "vc+sd-jwt";
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s6.2-presented-sdjwtvp.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        JsonNode keyBindingClaims = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.2-key-binding-claims.json");
        String presentation = sdJwtVP.present(null, keyBindingClaims, TestSettings.getInstance().getHolderSignerContext(), jwsType);
        SdJwtVP presenteSdJwtVP = SdJwtVP.of((String)presentation);
        Assert.assertTrue((boolean)presenteSdJwtVP.getKeyBindingJWT().isPresent());
        ((KeyBindingJWT)presenteSdJwtVP.getKeyBindingJWT().get()).verifySignature(TestSettings.verifierContextFrom(presenteSdJwtVP.getCnfClaim(), "ES256"));
        ((KeyBindingJWT)presenteSdJwtVP.getKeyBindingJWT().get()).verifySignature(TestSettings.getInstance().getIssuerVerifierContext());
    }

    @Test
    public void testS6_2_PresentationPartialDisclosure() throws VerificationException {
        String jwsType = "vc+sd-jwt";
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s6.2-presented-sdjwtvp.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        JsonNode keyBindingClaims = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.2-key-binding-claims.json");
        String presentation = sdJwtVP.present(Arrays.asList("jsu9yVulwQQlhFlM_3JlzMaSFzglhQG0DpfayQwLUK4"), keyBindingClaims, TestSettings.getInstance().getHolderSignerContext(), jwsType);
        SdJwtVP presenteSdJwtVP = SdJwtVP.of((String)presentation);
        Assert.assertTrue((boolean)presenteSdJwtVP.getKeyBindingJWT().isPresent());
        ((KeyBindingJWT)presenteSdJwtVP.getKeyBindingJWT().get()).verifySignature(TestSettings.verifierContextFrom(presenteSdJwtVP.getCnfClaim(), "ES256"));
    }
}

