/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.info;

import java.util.Date;
import java.util.Locale;

public class SystemInfoRepresentation {
    private String version;
    private String serverTime;
    private String uptime;
    private long uptimeMillis;
    private String javaVersion;
    private String javaVendor;
    private String javaVm;
    private String javaVmVersion;
    private String javaRuntime;
    private String javaHome;
    private String osName;
    private String osArchitecture;
    private String osVersion;
    private String fileEncoding;
    private String userName;
    private String userDir;
    private String userTimezone;
    private String userLocale;

    public static SystemInfoRepresentation create(long serverStartupTime, String serverVersion) {
        SystemInfoRepresentation rep = new SystemInfoRepresentation();
        rep.version = serverVersion;
        rep.serverTime = new Date().toString();
        rep.uptimeMillis = System.currentTimeMillis() - serverStartupTime;
        rep.uptime = SystemInfoRepresentation.formatUptime(rep.uptimeMillis);
        rep.javaVersion = System.getProperty("java.version");
        rep.javaVendor = System.getProperty("java.vendor");
        rep.javaVm = System.getProperty("java.vm.name");
        rep.javaVmVersion = System.getProperty("java.vm.version");
        rep.javaRuntime = System.getProperty("java.runtime.name");
        rep.javaHome = System.getProperty("java.home");
        rep.osName = System.getProperty("os.name");
        rep.osArchitecture = System.getProperty("os.arch");
        rep.osVersion = System.getProperty("os.version");
        rep.fileEncoding = System.getProperty("file.encoding");
        rep.userName = System.getProperty("user.name");
        rep.userDir = System.getProperty("user.dir");
        rep.userTimezone = System.getProperty("user.timezone");
        if (System.getProperty("user.country") != null && System.getProperty("user.language") != null) {
            rep.userLocale = new Locale(System.getProperty("user.language"), System.getProperty("user.country")).toString();
        }
        return rep;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(String serverTime) {
        this.serverTime = serverTime;
    }

    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public long getUptimeMillis() {
        return this.uptimeMillis;
    }

    public void setUptimeMillis(long uptimeMillis) {
        this.uptimeMillis = uptimeMillis;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public void setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor;
    }

    public String getJavaVm() {
        return this.javaVm;
    }

    public void setJavaVm(String javaVm) {
        this.javaVm = javaVm;
    }

    public String getJavaVmVersion() {
        return this.javaVmVersion;
    }

    public void setJavaVmVersion(String javaVmVersion) {
        this.javaVmVersion = javaVmVersion;
    }

    public String getJavaRuntime() {
        return this.javaRuntime;
    }

    public void setJavaRuntime(String javaRuntime) {
        this.javaRuntime = javaRuntime;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public void setUserDir(String userDir) {
        this.userDir = userDir;
    }

    public String getUserTimezone() {
        return this.userTimezone;
    }

    public void setUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(String userLocale) {
        this.userLocale = userLocale;
    }

    private static String formatUptime(long uptime) {
        long diffInSeconds = uptime / 1000L;
        long[] diff = new long[]{0L, 0L, 0L, 0L};
        diff[3] = diffInSeconds >= 60L ? diffInSeconds % 60L : diffInSeconds;
        diff[2] = (diffInSeconds /= 60L) >= 60L ? diffInSeconds % 60L : diffInSeconds;
        diff[1] = (diffInSeconds /= 60L) >= 24L ? diffInSeconds % 24L : diffInSeconds;
        diff[0] = diffInSeconds /= 24L;
        return String.format("%d day%s, %d hour%s, %d minute%s, %d second%s", diff[0], diff[0] != 1L ? "s" : "", diff[1], diff[1] != 1L ? "s" : "", diff[2], diff[2] != 1L ? "s" : "", diff[3], diff[3] != 1L ? "s" : "");
    }
}

