/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.RSATokenVerifier;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.util.JsonSerialization;

public abstract class RSAVerifierTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    private static KeyPair idpPair;
    private static KeyPair badPair;
    private AccessToken token;

    @BeforeClass
    public static void setupCerts() throws Exception {
        badPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        idpPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }

    @Before
    public void initTest() {
        this.token = new AccessToken();
        this.token.type("Bearer").subject("CN=Client").issuer("http://localhost:8080/auth/realm").addAccess("service").addRole("admin");
    }

    @Test
    public void testSimpleVerification() throws Exception {
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        System.out.print("encoded size: " + encoded.length());
        AccessToken token = this.verifySkeletonKeyToken(encoded);
        Assert.assertTrue((boolean)token.getResourceAccess("service").getRoles().contains("admin"));
        Assert.assertEquals((Object)"CN=Client", (Object)token.getSubject());
    }

    @Test
    public void testVerificationWithAddedX5cAndJwk() throws Exception {
        KeyPair caKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        X509Certificate caCertificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)caKeyPair, (String)"root");
        X509Certificate idpCertificate = CertificateUtils.generateV3Certificate((KeyPair)idpPair, (PrivateKey)caKeyPair.getPrivate(), (X509Certificate)caCertificate, (String)"idp");
        JWK jwk = JWKBuilder.create().rsa((Key)idpPair.getPublic());
        String encoded = new JWSBuilder().jwk(jwk).x5c(Arrays.asList(idpCertificate, caCertificate)).jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        TokenVerifier tokenVerifier = TokenVerifier.create((String)encoded, JsonWebToken.class);
        this.verifySkeletonKeyToken(encoded);
        Assert.assertTrue((boolean)this.token.getResourceAccess("service").getRoles().contains("admin"));
        Assert.assertEquals((Object)"CN=Client", (Object)this.token.getSubject());
        List x5c = tokenVerifier.getHeader().getX5c();
        Assert.assertEquals((long)2L, (long)x5c.size());
        Assert.assertEquals((Object)Base64.encodeBytes((byte[])idpCertificate.getEncoded()), x5c.get(0));
        Assert.assertEquals((Object)Base64.encodeBytes((byte[])caCertificate.getEncoded()), x5c.get(1));
        Assert.assertEquals((Object)JsonSerialization.mapper.convertValue((Object)jwk, Map.class), (Object)JsonSerialization.mapper.convertValue((Object)tokenVerifier.getHeader().getKey(), Map.class));
    }

    private AccessToken verifySkeletonKeyToken(String encoded) throws VerificationException {
        return RSATokenVerifier.verifyToken((String)encoded, (PublicKey)idpPair.getPublic(), (String)"http://localhost:8080/auth/realm");
    }

    public void testSpeed() throws Exception {
        byte[] tokenBytes = JsonSerialization.writeValueAsBytes((Object)this.token);
        long start = System.currentTimeMillis();
        int count = 50000;
        for (int i = 0; i < count; ++i) {
            String encoded = new JWSBuilder().content(tokenBytes).rsa256(idpPair.getPrivate());
            this.verifySkeletonKeyToken(encoded);
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("took: " + end);
    }

    @Test
    public void testBadSignature() {
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(badPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testNotBeforeGood() throws Exception {
        this.token.nbf(Long.valueOf((long)Time.currentTime() - 100L));
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        v = this.verifySkeletonKeyToken(encoded);
    }

    @Test
    public void testNotBeforeBad() {
        this.token.nbf(Long.valueOf((long)Time.currentTime() + 100L));
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    @Test
    public void testExpirationGood() throws Exception {
        this.token.exp(Long.valueOf((long)Time.currentTime() + 100L));
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        v = this.verifySkeletonKeyToken(encoded);
    }

    @Test
    public void testExpirationBad() {
        this.token.exp(Long.valueOf((long)Time.currentTime() - 100L));
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testTokenAuth() {
        this.token = new AccessToken();
        this.token.subject("CN=Client").issuer("http://localhost:8080/auth/realms/demo").addAccess("service").addRole("admin").verifyCaller(Boolean.valueOf(true));
        this.token.setEmail("bill@jboss.org");
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        System.out.println("token size: " + encoded.length());
        AccessToken v = null;
        try {
            v = this.verifySkeletonKeyToken(encoded);
            Assert.fail();
        }
        catch (VerificationException verificationException) {
            // empty catch block
        }
    }

    @Test
    public void testAudience() throws Exception {
        this.token.addAudience("my-app");
        this.token.addAudience("your-app");
        String encoded = new JWSBuilder().jsonContent((Object)this.token).rsa256(idpPair.getPrivate());
        this.verifyAudience(encoded, "my-app");
        this.verifyAudience(encoded, "your-app");
        try {
            this.verifyAudience(encoded, "other-app");
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
        try {
            this.verifyAudience(encoded, null);
            Assert.fail();
        }
        catch (VerificationException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void verifyAudience(String encodedToken, String expectedAudience) throws VerificationException {
        TokenVerifier.create((String)encodedToken, AccessToken.class).publicKey(idpPair.getPublic()).realmUrl("http://localhost:8080/auth/realm").audience(new String[]{expectedAudience}).verify();
    }
}

