/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.util.UriUtils;

public class UriUtilsTest {
    @Test
    public void testOrigins() {
        this.assertValid("http://test");
        this.assertValid("http://test:8080");
        this.assertValid("https://test");
        this.assertValid("http://test.com");
        this.assertValid("https://test.com");
        this.assertValid("https://test.com:8080");
        this.assertValid("http://sub.test.com");
        this.assertValid("https://sub.test.com");
        this.assertValid("https://sub.test.com:8080");
        this.assertValid("http://192.168.123.123");
        this.assertValid("https://192.168.123.123");
        this.assertValid("https://192.168.123.123:8080");
        this.assertValid("https://sub-sub.test.com");
        this.assertValid("https://sub.test-test.com");
        this.assertInvalid("https://test/");
        this.assertInvalid("{");
        this.assertInvalid("https://{}");
        this.assertInvalid("https://)");
        this.assertInvalid("http://test:test");
        this.assertInvalid("http://test:8080:8080");
    }

    private void assertValid(String origin) {
        Assert.assertTrue((boolean)UriUtils.isOrigin((String)origin));
    }

    private void assertInvalid(String origin) {
        Assert.assertFalse((boolean)UriUtils.isOrigin((String)origin));
    }

    @Test
    public void testStripQueryParam() {
        Assert.assertEquals((Object)"http://localhost", (Object)UriUtils.stripQueryParam((String)"http://localhost?login_hint=michael", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost", (Object)UriUtils.stripQueryParam((String)"http://localhost?login_hint=michael@me.com", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?param=test&login_hint=michael", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?param=test&login_hint=michael@me.com", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?login_hint=michael&param=test", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?login_hint=michael@me.com&param=test", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?pre=test&param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?pre=test&login_hint=michael&param=test", (String)"login_hint"));
        Assert.assertEquals((Object)"http://localhost?pre=test&param=test", (Object)UriUtils.stripQueryParam((String)"http://localhost?pre=test&login_hint=michael@me.com&param=test", (String)"login_hint"));
    }
}

