/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.jose.jwk.JWKUtil;

public class JWKUtilTest {
    @Test
    public void testBigInteger256bit33bytes() {
        BigInteger bi = new BigInteger("106978455244904118504029146852168092303170743300495577837424194202315290288011");
        Assert.assertEquals((long)256L, (long)bi.bitLength());
        Assert.assertEquals((long)33L, (long)bi.toByteArray().length);
        byte[] bytes = JWKUtil.toIntegerBytes((BigInteger)bi, (int)256);
        Assert.assertEquals((long)32L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
    }

    @Test
    public void testBigInteger521bit66bytes() {
        BigInteger bi = new BigInteger("6734373674814691396115132088653791161514881890352734019594374673014557152383502505390504647094584246525242385854438954847939940255492102589858760446395824148");
        Assert.assertEquals((long)521L, (long)bi.bitLength());
        Assert.assertEquals((long)66L, (long)bi.toByteArray().length);
        byte[] bytes = JWKUtil.toIntegerBytes((BigInteger)bi, (int)521);
        Assert.assertEquals((long)66L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
    }

    @Test
    public void testBigInteger519bit65bytes() {
        BigInteger bi = new BigInteger("1056406612537758216307284361941630998827278875643943164504783316640832530092186610655845467862847840003942818620330993843247554843391332954698064457598103921");
        Assert.assertEquals((long)519L, (long)bi.bitLength());
        Assert.assertEquals((long)65L, (long)bi.toByteArray().length);
        byte[] bytes = JWKUtil.toIntegerBytes((BigInteger)bi, (int)521);
        Assert.assertEquals((long)66L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
        bytes = JWKUtil.toIntegerBytes((BigInteger)bi);
        Assert.assertEquals((long)65L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
    }

    @Test
    public void testBigInteger509bit65bytes() {
        BigInteger bi = new BigInteger("1020105336060806799317581876370378670178920448263046037385822665297838480884942245045412789346716977404456327079571798657084244307627713218035021026706753");
        Assert.assertEquals((long)509L, (long)bi.bitLength());
        Assert.assertEquals((long)64L, (long)bi.toByteArray().length);
        byte[] bytes = JWKUtil.toIntegerBytes((BigInteger)bi, (int)521);
        Assert.assertEquals((long)66L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
        bytes = JWKUtil.toIntegerBytes((BigInteger)bi);
        Assert.assertEquals((long)64L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
    }

    @Test
    public void testBigInteger380bit48bytes() {
        BigInteger bi = new BigInteger("1318324198847573133767761135109898830134893480775680898178696604234765693579204018161102886445531980641666395659568");
        Assert.assertEquals((long)380L, (long)bi.bitLength());
        Assert.assertEquals((long)48L, (long)bi.toByteArray().length);
        byte[] bytes = JWKUtil.toIntegerBytes((BigInteger)bi, (int)384);
        Assert.assertEquals((long)48L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
        bytes = JWKUtil.toIntegerBytes((BigInteger)bi);
        Assert.assertEquals((long)48L, (long)bytes.length);
        Assert.assertEquals((Object)bi, (Object)new BigInteger(1, bytes));
    }

    @Test
    public void testBigInteger380bit48bytesErrorFor256() {
        BigInteger bi = new BigInteger("1318324198847573133767761135109898830134893480775680898178696604234765693579204018161102886445531980641666395659568");
        Assert.assertEquals((long)380L, (long)bi.bitLength());
        Assert.assertEquals((long)48L, (long)bi.toByteArray().length);
        AssertionError e = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> JWKUtil.toIntegerBytes((BigInteger)bi, (int)256)));
        Assert.assertEquals((Object)"Incorrect big integer with bit length 380 for 256", (Object)((Throwable)((Object)e)).getMessage());
    }
}

