/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.DisclosureRedList;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestSettings;

public abstract class SdJwtVerificationTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    static ObjectMapper mapper = new ObjectMapper();
    static TestSettings testSettings = TestSettings.getInstance();

    @Test
    public void settingsTest() {
        SignatureSignerContext issuerSignerContext = SdJwtVerificationTest.testSettings.issuerSigContext;
        Assert.assertNotNull((Object)issuerSignerContext);
    }

    @Test
    public void testSdJwtVerification_FlatSdJwt() throws VerificationException {
        for (String hashAlg : Arrays.asList("sha-256", "sha-384", "sha-512")) {
            SdJwt sdJwt = this.exampleFlatSdJwtV1().withHashAlgorithm(hashAlg).build();
            sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
        }
    }

    @Test
    public void testSdJwtVerification_EnforceIdempotence() throws VerificationException {
        SdJwt sdJwt = this.exampleFlatSdJwtV1().build();
        sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
        sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
    }

    @Test
    public void testSdJwtVerification_SdJwtWithUndisclosedNestedFields() throws VerificationException {
        SdJwt sdJwt = this.exampleSdJwtWithUndisclosedNestedFieldsV1().build();
        sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
    }

    @Test
    public void testSdJwtVerification_SdJwtWithUndisclosedArrayElements() throws Exception {
        SdJwt sdJwt = this.exampleSdJwtWithUndisclosedArrayElementsV1().build();
        sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
    }

    @Test
    public void testSdJwtVerification_RecursiveSdJwt() throws Exception {
        SdJwt sdJwt = this.exampleRecursiveSdJwtV1().build();
        sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build());
    }

    @Test
    public void sdJwtVerificationShouldFail_OnInsecureHashAlg() {
        SdJwt sdJwt = this.exampleFlatSdJwtV1().withHashAlgorithm("sha-224").build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build()));
        Assert.assertEquals((Object)"Unexpected or insecure hash algorithm: sha-224", (Object)exception.getMessage());
    }

    @Test
    public void sdJwtVerificationShouldFail_WithWrongVerifier() {
        SdJwt sdJwt = this.exampleFlatSdJwtV1().build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(Collections.singletonList(SdJwtVerificationTest.testSettings.holderVerifierContext), this.defaultIssuerSignedJwtVerificationOpts().build()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid Issuer-Signed JWT: Signature could not be verified"));
    }

    @Test
    public void sdJwtVerificationShouldFail_IfExpired() {
        long now = Instant.now().getEpochSecond();
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        claimSet.put("exp", now - 1000L);
        SdJwt sdJwtV1 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().build()).build();
        SdJwt sdJwtV2 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withRedListedClaimNames(DisclosureRedList.of(Collections.emptySet())).withUndisclosedClaim("exp", "eluV5Og3gSNII8EYnsxA_A").build()).build();
        for (SdJwt sdJwt : Arrays.asList(sdJwtV1, sdJwtV2)) {
            VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().withValidateExpirationClaim(true).build()));
            Assert.assertEquals((Object)"Issuer-Signed JWT: Invalid `exp` claim", (Object)exception.getMessage());
            Assert.assertEquals((Object)"JWT has expired", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void sdJwtVerificationShouldFail_IfExpired_CaseExpInvalid() {
        ObjectNode claimSet1 = mapper.createObjectNode();
        claimSet1.put("given_name", "John");
        ObjectNode claimSet2 = mapper.createObjectNode();
        claimSet1.put("given_name", "John");
        claimSet1.put("exp", "should-not-be-a-string");
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").build();
        SdJwt sdJwtV1 = this.exampleFlatSdJwtV2(claimSet1, disclosureSpec).build();
        SdJwt sdJwtV2 = this.exampleFlatSdJwtV2(claimSet2, disclosureSpec).build();
        for (SdJwt sdJwt : Arrays.asList(sdJwtV1, sdJwtV2)) {
            VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().withValidateExpirationClaim(true).build()));
            Assert.assertEquals((Object)"Issuer-Signed JWT: Invalid `exp` claim", (Object)exception.getMessage());
            Assert.assertEquals((Object)"Missing or invalid 'exp' claim", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void sdJwtVerificationShouldFail_IfIssuedInTheFuture() {
        long now = Instant.now().getEpochSecond();
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        claimSet.put("iat", now + 1000L);
        SdJwt sdJwtV1 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().build()).build();
        SdJwt sdJwtV2 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withRedListedClaimNames(DisclosureRedList.of(Collections.emptySet())).withUndisclosedClaim("iat", "eluV5Og3gSNII8EYnsxA_A").build()).build();
        for (SdJwt sdJwt : Arrays.asList(sdJwtV1, sdJwtV2)) {
            VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().withValidateIssuedAtClaim(true).build()));
            Assert.assertEquals((Object)"Issuer-Signed JWT: Invalid `iat` claim", (Object)exception.getMessage());
            Assert.assertEquals((Object)"JWT issued in the future", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void sdJwtVerificationShouldFail_IfNbfInvalid() {
        long now = Instant.now().getEpochSecond();
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        claimSet.put("nbf", now + 1000L);
        SdJwt sdJwtV1 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().build()).build();
        SdJwt sdJwtV2 = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withRedListedClaimNames(DisclosureRedList.of(Collections.emptySet())).withUndisclosedClaim("iat", "eluV5Og3gSNII8EYnsxA_A").build()).build();
        for (SdJwt sdJwt : Arrays.asList(sdJwtV1, sdJwtV2)) {
            VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().withValidateNotBeforeClaim(true).build()));
            Assert.assertEquals((Object)"Issuer-Signed JWT: Invalid `nbf` claim", (Object)exception.getMessage());
            Assert.assertEquals((Object)"JWT is not yet valid", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void sdJwtVerificationShouldFail_IfSdArrayElementIsNotString() throws JsonProcessingException {
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        claimSet.set("_sd", mapper.readTree("[123]"));
        SdJwt sdJwt = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().build()).build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build()));
        Assert.assertEquals((Object)"Unexpected non-string element inside _sd array: 123", (Object)exception.getMessage());
    }

    @Test
    public void sdJwtVerificationShouldFail_IfForbiddenClaimNames() {
        for (String forbiddenClaimName : Arrays.asList("_sd", "...")) {
            ObjectNode claimSet = mapper.createObjectNode();
            claimSet.put(forbiddenClaimName, "Value");
            SdJwt sdJwt = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withUndisclosedClaim(forbiddenClaimName, "eluV5Og3gSNII8EYnsxA_A").build()).build();
            VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build()));
            Assert.assertEquals((Object)"Disclosure claim name must not be '_sd' or '...'", (Object)exception.getMessage());
        }
    }

    @Test
    public void sdJwtVerificationShouldFail_IfDuplicateDigestValue() {
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        SdJwt sdJwt = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withDecoyClaim("G02NSrQfjFXQ7Io09syajA").withDecoyClaim("G02NSrQfjFXQ7Io09syajA").build()).build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build()));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("A digest was encountered more than once:"));
    }

    @Test
    public void sdJwtVerificationShouldFail_IfDuplicateSaltValue() {
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("given_name", "John");
        claimSet.put("family_name", "Doe");
        String salt = "eluV5Og3gSNII8EYnsxA_A";
        SdJwt sdJwt = this.exampleFlatSdJwtV2(claimSet, DisclosureSpec.builder().withUndisclosedClaim("given_name", salt).withUndisclosedClaim("family_name", salt).build()).build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwt.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build()));
        Assert.assertEquals((Object)("A salt value was reused: " + salt), (Object)exception.getMessage());
    }

    private List<SignatureVerifierContext> defaultIssuerVerifyingKeys() {
        return Collections.singletonList(SdJwtVerificationTest.testSettings.issuerVerifierContext);
    }

    private IssuerSignedJwtVerificationOpts.Builder defaultIssuerSignedJwtVerificationOpts() {
        return IssuerSignedJwtVerificationOpts.builder().withValidateIssuedAtClaim(false).withValidateExpirationClaim(false).withValidateNotBeforeClaim(false);
    }

    private SdJwt.Builder exampleFlatSdJwtV1() {
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("sub", "6c5c0a49-b589-431d-bae7-219122a9ec2c");
        claimSet.put("given_name", "John");
        claimSet.put("family_name", "Doe");
        claimSet.put("email", "john.doe@example.com");
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("email", "eI8ZWm9QnKPpNPeNenHdhQ").withDecoyClaim("G02NSrQfjFXQ7Io09syajA").build();
        return SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet((JsonNode)claimSet).withSigner(SdJwtVerificationTest.testSettings.issuerSigContext);
    }

    private SdJwt.Builder exampleFlatSdJwtV2(ObjectNode claimSet, DisclosureSpec disclosureSpec) {
        return SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet((JsonNode)claimSet).withSigner(SdJwtVerificationTest.testSettings.issuerSigContext);
    }

    private SdJwt exampleAddrSdJwt() {
        ObjectNode addressClaimSet = mapper.createObjectNode();
        addressClaimSet.put("street_address", "Rue des Oliviers");
        addressClaimSet.put("city", "Paris");
        addressClaimSet.put("country", "France");
        DisclosureSpec addrDisclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("street_address", "AJx-095VPrpTtN4QMOqROA").withUndisclosedClaim("city", "G02NSrQfjFXQ7Io09syajA").withDecoyClaim("G02NSrQfjFXQ7Io09syajA").build();
        return SdJwt.builder().withDisclosureSpec(addrDisclosureSpec).withClaimSet((JsonNode)addressClaimSet).build();
    }

    private SdJwt.Builder exampleSdJwtWithUndisclosedNestedFieldsV1() {
        SdJwt addrSdJWT = this.exampleAddrSdJwt();
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("sub", "6c5c0a49-b589-431d-bae7-219122a9ec2c");
        claimSet.put("given_name", "John");
        claimSet.put("family_name", "Doe");
        claimSet.put("email", "john.doe@example.com");
        claimSet.set("address", addrSdJWT.asNestedPayload());
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("email", "eI8ZWm9QnKPpNPeNenHdhQ").build();
        return SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet((JsonNode)claimSet).withNestedSdJwt(addrSdJWT).withSigner(SdJwtVerificationTest.testSettings.issuerSigContext);
    }

    private SdJwt.Builder exampleSdJwtWithUndisclosedArrayElementsV1() throws JsonProcessingException {
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("sub", "6c5c0a49-b589-431d-bae7-219122a9ec2c");
        claimSet.put("given_name", "John");
        claimSet.put("family_name", "Doe");
        claimSet.put("email", "john.doe@example.com");
        claimSet.set("nationalities", mapper.readTree("[\"US\", \"DE\"]"));
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("email", "eI8ZWm9QnKPpNPeNenHdhQ").withUndisclosedArrayElt("nationalities", Integer.valueOf(1), "nPuoQnkRFq3BIeAm7AnXFA").withDecoyArrayElt("nationalities", Integer.valueOf(2), "G02NSrQfjFXQ7Io09syajA").build();
        return SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet((JsonNode)claimSet).withSigner(SdJwtVerificationTest.testSettings.issuerSigContext);
    }

    private SdJwt.Builder exampleRecursiveSdJwtV1() {
        SdJwt addrSdJWT = this.exampleAddrSdJwt();
        ObjectNode claimSet = mapper.createObjectNode();
        claimSet.put("sub", "6c5c0a49-b589-431d-bae7-219122a9ec2c");
        claimSet.put("given_name", "John");
        claimSet.put("family_name", "Doe");
        claimSet.put("email", "john.doe@example.com");
        claimSet.set("address", addrSdJWT.asNestedPayload());
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("email", "eI8ZWm9QnKPpNPeNenHdhQ").withUndisclosedClaim("address", "BZFzhQsdPfZY1WSL-1GXKg").build();
        return SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet((JsonNode)claimSet).withNestedSdJwt(addrSdJWT).withSigner(SdJwtVerificationTest.testSettings.issuerSigContext);
    }
}

