/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.sdjwtvp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.TestSettings;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.vp.KeyBindingJWT;
import org.keycloak.sdjwt.vp.KeyBindingJwtVerificationOpts;
import org.keycloak.sdjwt.vp.SdJwtVP;

public abstract class SdJwtVPVerificationTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    static ObjectMapper mapper = new ObjectMapper();
    static TestSettings testSettings = TestSettings.getInstance();

    @Test
    public void testVerif_s20_1_sdjwt_with_kb() throws VerificationException {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s20.1-sdjwt+kb.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), this.defaultKeyBindingJwtVerificationOpts().build());
    }

    @Test
    public void testVerif_s20_8_sdjwt_with_kb__AltCnfCurves() throws VerificationException {
        List<String> entries = Arrays.asList("sdjwt/s20.8-sdjwt+kb--es384.txt", "sdjwt/s20.8-sdjwt+kb--es512.txt");
        for (String entry : entries) {
            String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), entry);
            SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
            sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), this.defaultKeyBindingJwtVerificationOpts().build());
        }
    }

    @Test
    public void testVerif_s20_8_sdjwt_with_kb__CnfRSA() throws VerificationException {
        List<String> entries = Arrays.asList("sdjwt/s20.8-sdjwt+kb--cnf-rsa-rs256.txt", "sdjwt/s20.8-sdjwt+kb--cnf-rsa-ps256.txt", "sdjwt/s20.8-sdjwt+kb--cnf-rsa-ps384.txt", "sdjwt/s20.8-sdjwt+kb--cnf-rsa-ps512.txt");
        for (String entry : entries) {
            String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), entry);
            SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
            sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), this.defaultKeyBindingJwtVerificationOpts().build());
        }
    }

    @Test
    public void testVerifKeyBindingNotRequired() throws VerificationException {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s6.2-presented-sdjwtvp.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), this.defaultKeyBindingJwtVerificationOpts().withKeyBindingRequired(false).build());
    }

    @Test
    public void testShouldFail_IfExtraDisclosureWithNoDigest() {
        this.testShouldFailGeneric("sdjwt/s20.6-sdjwt+kb--disclosure-with-no-digest.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "At least one disclosure is not protected by digest", null);
    }

    @Test
    public void testShouldFail_IfFieldDisclosureLengthIncorrect() {
        this.testShouldFailGeneric("sdjwt/s20.7-sdjwt+kb--invalid-field-disclosure.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "A field disclosure must contain exactly three elements", null);
    }

    @Test
    public void testShouldFail_IfArrayElementDisclosureLengthIncorrect() {
        this.testShouldFailGeneric("sdjwt/s20.7-sdjwt+kb--invalid-array-elt-disclosure.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "An array element disclosure must contain exactly two elements", null);
    }

    @Test
    public void testShouldFail_IfKeyBindingRequiredAndMissing() {
        this.testShouldFailGeneric("sdjwt/s6.2-presented-sdjwtvp.txt", this.defaultKeyBindingJwtVerificationOpts().withKeyBindingRequired(true).build(), "Missing Key Binding JWT", null);
    }

    @Test
    public void testShouldFail_IfKeyBindingJwtSignatureInvalid() {
        this.testShouldFailGeneric("sdjwt/s20.1-sdjwt+kb--wrong-kb-signature.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "Key binding JWT invalid", "VerificationException: Invalid jws signature");
    }

    @Test
    public void testShouldFail_IfNoCnfClaim() {
        this.testShouldFailGeneric("sdjwt/s20.2-sdjwt+kb--no-cnf-claim.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "No cnf claim in Issuer-signed JWT for key binding", null);
    }

    @Test
    public void testShouldFail_IfWrongKbTyp() {
        this.testShouldFailGeneric("sdjwt/s20.3-sdjwt+kb--wrong-kb-typ.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "Key Binding JWT is not of declared typ kb+jwt", null);
    }

    @Test
    public void testShouldFail_IfReplayChecksFail_Nonce() {
        this.testShouldFailGeneric("sdjwt/s20.1-sdjwt+kb.txt", this.defaultKeyBindingJwtVerificationOpts().withNonce("abcd").build(), "Key binding JWT: Unexpected `nonce` value", null);
    }

    @Test
    public void testShouldFail_IfReplayChecksFail_Aud() {
        this.testShouldFailGeneric("sdjwt/s20.1-sdjwt+kb.txt", this.defaultKeyBindingJwtVerificationOpts().withAud("abcd").build(), "Key binding JWT: Unexpected `aud` value", null);
    }

    @Test
    public void testShouldFail_IfKbSdHashWrongFormat() {
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.set("sd_hash", mapper.valueToTree((Object)1234));
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().build(), "Key binding JWT: Claim `sd_hash` missing or not a string", null);
    }

    @Test
    public void testShouldFail_IfKbSdHashInvalid() {
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.put("sd_hash", "c3FmZHFmZGZlZXNkZmZi");
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().build(), "Key binding JWT: Invalid `sd_hash` digest", null);
    }

    @Test
    public void testShouldFail_IfKbIssuedInFuture() {
        long now = Instant.now().getEpochSecond();
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.set("iat", mapper.valueToTree((Object)(now + 1000L)));
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().build(), "Key binding JWT: Invalid `iat` claim", "jwt issued in the future");
    }

    @Test
    public void testShouldFail_IfKbTooOld() {
        long issuerSignedJwtIat = 1683000000L;
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.set("iat", mapper.valueToTree((Object)(issuerSignedJwtIat - 120L)));
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().withAllowedMaxAge(60).build(), "Key binding JWT is too old", null);
    }

    @Test
    public void testShouldFail_IfKbExpired() {
        long now = Instant.now().getEpochSecond();
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.set("exp", mapper.valueToTree((Object)(now - 1000L)));
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().withValidateExpirationClaim(true).build(), "Key binding JWT: Invalid `exp` claim", "jwt has expired");
    }

    @Test
    public void testShouldFail_IfKbNotBeforeTimeYet() {
        long now = Instant.now().getEpochSecond();
        ObjectNode kbPayload = this.exampleKbPayload();
        kbPayload.set("nbf", mapper.valueToTree((Object)(now + 1000L)));
        this.testShouldFailGeneric2((JsonNode)kbPayload, this.defaultKeyBindingJwtVerificationOpts().withValidateNotBeforeClaim(true).build(), "Key binding JWT: Invalid `nbf` claim", "jwt not valid yet");
    }

    @Test
    public void testShouldFail_IfCnfNotJwk() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s20.8-sdjwt+kb--cnf-is-not-jwk.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        UnsupportedOperationException exception = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), this.defaultKeyBindingJwtVerificationOpts().build()));
        Assert.assertEquals((Object)"Only cnf/jwk claim supported", (Object)exception.getMessage());
    }

    @Test
    public void testShouldFail_IfCnfJwkCantBeParsed() {
        this.testShouldFailGeneric("sdjwt/s20.8-sdjwt+kb--cnf-jwk-is-malformed.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "Could not process cnf/jwk", "Unsupported or invalid JWK");
    }

    @Test
    public void testShouldFail_IfCnfJwkCantBeParsed2() {
        this.testShouldFailGeneric("sdjwt/s20.8-sdjwt+kb--cnf-hmac.txt", this.defaultKeyBindingJwtVerificationOpts().build(), "Could not process cnf/jwk", "Unsupported or invalid JWK");
    }

    private void testShouldFailGeneric(String testFilePath, KeyBindingJwtVerificationOpts keyBindingJwtVerificationOpts, String exceptionMessage, String exceptionCauseMessage) {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), testFilePath);
        SdJwtVP sdJwtVP = SdJwtVP.of((String)sdJwtVPString);
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), keyBindingJwtVerificationOpts));
        Assert.assertEquals((Object)exceptionMessage, (Object)exception.getMessage());
        if (exceptionCauseMessage != null) {
            MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)exceptionCauseMessage));
        }
    }

    private void testShouldFailGeneric2(JsonNode kbPayloadSubstitute, KeyBindingJwtVerificationOpts keyBindingJwtVerificationOpts, String exceptionMessage, String exceptionCauseMessage) {
        KeyBindingJWT keyBindingJWT = KeyBindingJWT.from((JsonNode)kbPayloadSubstitute, (SignatureSignerContext)SdJwtVPVerificationTest.testSettings.holderSigContext, (String)"kb+jwt");
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s20.1-sdjwt+kb.txt");
        SdJwtVP sdJwtVP = SdJwtVP.of((String)(sdJwtVPString.substring(0, sdJwtVPString.lastIndexOf("~") + 1) + keyBindingJWT.toJws()));
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJwtVP.verify(this.defaultIssuerVerifyingKeys(), this.defaultIssuerSignedJwtVerificationOpts().build(), keyBindingJwtVerificationOpts));
        Assert.assertEquals((Object)exceptionMessage, (Object)exception.getMessage());
        if (exceptionCauseMessage != null) {
            Assert.assertEquals((Object)exceptionCauseMessage, (Object)exception.getCause().getMessage());
        }
    }

    private List<SignatureVerifierContext> defaultIssuerVerifyingKeys() {
        return Collections.singletonList(SdJwtVPVerificationTest.testSettings.issuerVerifierContext);
    }

    private IssuerSignedJwtVerificationOpts.Builder defaultIssuerSignedJwtVerificationOpts() {
        return IssuerSignedJwtVerificationOpts.builder().withValidateIssuedAtClaim(false).withValidateNotBeforeClaim(false);
    }

    private KeyBindingJwtVerificationOpts.Builder defaultKeyBindingJwtVerificationOpts() {
        return KeyBindingJwtVerificationOpts.builder().withKeyBindingRequired(true).withAllowedMaxAge(Integer.MAX_VALUE).withNonce("1234567890").withAud("https://verifier.example.org").withValidateExpirationClaim(false).withValidateNotBeforeClaim(false);
    }

    private ObjectNode exampleKbPayload() {
        ObjectNode payload = mapper.createObjectNode();
        payload.put("nonce", "1234567890");
        payload.put("aud", "https://verifier.example.org");
        payload.put("sd_hash", "X9RrrfWt_70gHzOcovGSIt4Fms9Tf2g2hjlWVI_cxZg");
        payload.set("iat", mapper.valueToTree((Object)1702315679));
        return payload;
    }
}

