/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jwk.ECPublicJWK;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jwk.RSAPublicJWK;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.util.JsonSerialization;

public abstract class JWKTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void publicRs256() throws Exception {
        KeyPair keyPair = CryptoIntegration.getProvider().getKeyPairGen("RSA").generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"Test");
        JWK jwk = JWKBuilder.create().kid(KeyUtils.createKeyId((Key)publicKey)).algorithm("RS256").rsa((Key)publicKey, certificate);
        Assert.assertNotNull((Object)jwk.getKeyId());
        Assert.assertEquals((Object)"RSA", (Object)jwk.getKeyType());
        Assert.assertEquals((Object)"RS256", (Object)jwk.getAlgorithm());
        Assert.assertEquals((Object)"sig", (Object)jwk.getPublicKeyUse());
        Assert.assertTrue((boolean)(jwk instanceof RSAPublicJWK));
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getModulus());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getPublicExponent());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getX509CertificateChain());
        Assert.assertEquals((Object)PemUtils.encodeCertificate((Certificate)certificate), (Object)((RSAPublicJWK)jwk).getX509CertificateChain()[0]);
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getSha1x509Thumbprint());
        Assert.assertEquals((Object)PemUtils.generateThumbprint((String[])((RSAPublicJWK)jwk).getX509CertificateChain(), (String)"SHA-1"), (Object)((RSAPublicJWK)jwk).getSha1x509Thumbprint());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getSha256x509Thumbprint());
        Assert.assertEquals((Object)PemUtils.generateThumbprint((String[])((RSAPublicJWK)jwk).getX509CertificateChain(), (String)"SHA-256"), (Object)((RSAPublicJWK)jwk).getSha256x509Thumbprint());
        String jwkJson = JsonSerialization.writeValueAsString((Object)jwk);
        PublicKey publicKeyFromJwk = JWKParser.create().parse(jwkJson).toPublicKey();
        Assert.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])publicKeyFromJwk.getEncoded());
        byte[] data = "Some test string".getBytes(StandardCharsets.UTF_8);
        byte[] sign = this.sign(data, "SHA256withRSA", keyPair.getPrivate());
        this.verify(data, sign, "SHA256withRSA", publicKeyFromJwk);
    }

    @Test
    public void publicRs256Chain() throws Exception {
        KeyPair keyPair = CryptoIntegration.getProvider().getKeyPairGen("RSA").generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        List<X509Certificate> certificates = Arrays.asList(CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"Test"), CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"Intermediate"));
        JWK jwk = JWKBuilder.create().kid(KeyUtils.createKeyId((Key)publicKey)).algorithm("RS256").rsa((Key)publicKey, certificates);
        Assert.assertNotNull((Object)jwk.getKeyId());
        Assert.assertEquals((Object)"RSA", (Object)jwk.getKeyType());
        Assert.assertEquals((Object)"RS256", (Object)jwk.getAlgorithm());
        Assert.assertEquals((Object)"sig", (Object)jwk.getPublicKeyUse());
        Assert.assertTrue((boolean)(jwk instanceof RSAPublicJWK));
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getModulus());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getPublicExponent());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getX509CertificateChain());
        Object[] expectedChain = new String[certificates.size()];
        for (int i = 0; i < certificates.size(); ++i) {
            expectedChain[i] = PemUtils.encodeCertificate((Certificate)certificates.get(i));
        }
        Assert.assertArrayEquals((Object[])expectedChain, (Object[])((RSAPublicJWK)jwk).getX509CertificateChain());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getSha1x509Thumbprint());
        Assert.assertEquals((Object)PemUtils.generateThumbprint((String[])((RSAPublicJWK)jwk).getX509CertificateChain(), (String)"SHA-1"), (Object)((RSAPublicJWK)jwk).getSha1x509Thumbprint());
        Assert.assertNotNull((Object)((RSAPublicJWK)jwk).getSha256x509Thumbprint());
        Assert.assertEquals((Object)PemUtils.generateThumbprint((String[])((RSAPublicJWK)jwk).getX509CertificateChain(), (String)"SHA-256"), (Object)((RSAPublicJWK)jwk).getSha256x509Thumbprint());
        String jwkJson = JsonSerialization.writeValueAsString((Object)jwk);
        PublicKey publicKeyFromJwk = JWKParser.create().parse(jwkJson).toPublicKey();
        Assert.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])publicKeyFromJwk.getEncoded());
        byte[] data = "Some test string".getBytes(StandardCharsets.UTF_8);
        byte[] sign = this.sign(data, "SHA256withRSA", keyPair.getPrivate());
        this.verify(data, sign, "SHA256withRSA", publicKeyFromJwk);
    }

    private void testPublicEs256(String algorithm) throws Exception {
        KeyPairGenerator keyGen = CryptoIntegration.getProvider().getKeyPairGen("EC");
        SecureRandom randomGen = new SecureRandom();
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(algorithm);
        keyGen.initialize(ecSpec, randomGen);
        KeyPair keyPair = keyGen.generateKeyPair();
        KeyPair keyPair2 = keyGen.generateKeyPair();
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"root");
        X509Certificate certificate2 = CertificateUtils.generateV3Certificate((KeyPair)keyPair2, (PrivateKey)keyPair.getPrivate(), (X509Certificate)certificate, (String)"child");
        certificate.verify(keyPair.getPublic());
        certificate2.verify(keyPair.getPublic());
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        JWK jwk = JWKBuilder.create().kid(KeyUtils.createKeyId((Key)keyPair.getPublic())).algorithm("ES256").ec((Key)publicKey);
        Assert.assertEquals((Object)"EC", (Object)jwk.getKeyType());
        Assert.assertEquals((Object)"ES256", (Object)jwk.getAlgorithm());
        Assert.assertEquals((Object)"sig", (Object)jwk.getPublicKeyUse());
        Assert.assertTrue((boolean)(jwk instanceof ECPublicJWK));
        ECPublicJWK ecJwk = (ECPublicJWK)jwk;
        Assert.assertNotNull((Object)ecJwk.getCrv());
        Assert.assertNotNull((Object)ecJwk.getX());
        Assert.assertNotNull((Object)ecJwk.getY());
        byte[] xBytes = Base64Url.decode((String)ecJwk.getX());
        byte[] yBytes = Base64Url.decode((String)ecJwk.getY());
        int expectedSize = (publicKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
        Assert.assertEquals((long)expectedSize, (long)xBytes.length);
        Assert.assertEquals((long)expectedSize, (long)yBytes.length);
        String jwkJson = JsonSerialization.writeValueAsString((Object)jwk);
        JWKParser parser = JWKParser.create().parse(jwkJson);
        ECPublicKey publicKeyFromJwk = (ECPublicKey)parser.toPublicKey();
        Assert.assertEquals((Object)publicKey.getW(), (Object)publicKeyFromJwk.getW());
        byte[] data = "Some test string".getBytes(StandardCharsets.UTF_8);
        byte[] sign = this.sign(data, "SHA256withECDSA", keyPair.getPrivate());
        this.verify(data, sign, "SHA256withECDSA", publicKeyFromJwk);
    }

    @Test
    public void testCertificateGenerationWithRsaAndEc() throws Exception {
        KeyPairGenerator keyGenRsa = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        KeyPairGenerator keyGenEc = CryptoIntegration.getProvider().getKeyPairGen("EC");
        SecureRandom randomGen = new SecureRandom();
        ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
        keyGenEc.initialize(ecSpec, randomGen);
        KeyPair keyPairRsa = keyGenRsa.generateKeyPair();
        KeyPair keyPairEc = keyGenEc.generateKeyPair();
        X509Certificate certificateRsa = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPairRsa, (String)"root");
        X509Certificate certificateEc = CertificateUtils.generateV3Certificate((KeyPair)keyPairEc, (PrivateKey)keyPairRsa.getPrivate(), (X509Certificate)certificateRsa, (String)"child");
        certificateRsa.verify(keyPairRsa.getPublic());
        certificateEc.verify(keyPairRsa.getPublic());
    }

    @Test
    public void testCertificateGenerationWithEcAndRsa() throws Exception {
        KeyPairGenerator keyGenRsa = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        KeyPairGenerator keyGenEc = CryptoIntegration.getProvider().getKeyPairGen("EC");
        SecureRandom randomGen = new SecureRandom();
        ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
        keyGenEc.initialize(ecSpec, randomGen);
        KeyPair keyPairRsa = keyGenRsa.generateKeyPair();
        KeyPair keyPairEc = keyGenEc.generateKeyPair();
        X509Certificate certificateEc = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPairEc, (String)"root");
        X509Certificate certificateRsa = CertificateUtils.generateV3Certificate((KeyPair)keyPairRsa, (PrivateKey)keyPairEc.getPrivate(), (X509Certificate)certificateEc, (String)"child");
        certificateRsa.verify(keyPairEc.getPublic());
        certificateEc.verify(keyPairEc.getPublic());
    }

    @Test
    public void publicEs256P256() throws Exception {
        this.testPublicEs256("secp256r1");
    }

    @Test
    public void publicEs256P521() throws Exception {
        this.testPublicEs256("secp521r1");
    }

    @Test
    public void publicEs256P384() throws Exception {
        this.testPublicEs256("secp384r1");
    }

    @Test
    public void parseRsa() {
        String jwkJson = "{   \"kty\": \"RSA\",   \"alg\": \"RS256\",   \"use\": \"sig\",   \"kid\": \"3121adaa80ace09f89d80899d4a5dc4ce33d0747\",   \"n\": \"soFDjoZ5mQ8XAA7reQAFg90inKAHk0DXMTizo4JuOsgzUbhcplIeZ7ks83hsEjm8mP8lUVaHMPMAHEIp3gu6Xxsg-s73ofx1dtt_Fo7aj8j383MFQGl8-FvixTVobNeGeC0XBBQjN8lEl-lIwOa4ZoERNAShplTej0ntDp7TQm0=\",   \"e\": \"AQAB\"  }";
        PublicKey key = JWKParser.create().parse(jwkJson).toPublicKey();
        Assert.assertEquals((Object)"RSA", (Object)key.getAlgorithm());
        Assert.assertEquals((Object)"X.509", (Object)key.getFormat());
    }

    @Test
    public void parseEc() {
        String jwkJson = "{\n    \"kty\": \"EC\",\n    \"use\": \"sig\",\n    \"crv\": \"P-384\",\n    \"kid\": \"KTGEM0qFeO9VGjTLjmXiE_R_eSBUkU87xmytygI1pFQ\",\n    \"x\": \"_pYSppQj0JkrXFQdJPOTiktUxy_giDnqc-PEmNShrWrZm8Ol6E5qB3m1kmZJ7HUF\",\n    \"y\": \"BVlstiJytsgOxrsC1VuNYdx86KKMeJg5WvJhEi-5kMpF2aMHZqbJCcIq0uRdzi7Q\",\n    \"alg\": \"ES256\"\n}";
        JWKParser sut = JWKParser.create().parse(jwkJson);
        PublicKey pub = sut.toPublicKey();
        Assert.assertNotNull((Object)pub);
        Assert.assertTrue((boolean)pub.getAlgorithm().startsWith("EC"));
        Assert.assertEquals((Object)"X.509", (Object)pub.getFormat());
    }

    @Test
    public void toPublicKey_EC() {
        ECPublicJWK ecJwk = new ECPublicJWK();
        ecJwk.setKeyType("EC");
        ecJwk.setCrv("P-256");
        ecJwk.setX("zHXlTZt3yU_oNnLIjgpt-ZaiStrYIzR2oxxq53J0uIs");
        ecJwk.setY("cOsAvnh6olE8KHWPHmB-pJawRWmTtbChmWtSeWZRJdc");
        JWKParser sut = JWKParser.create((JWK)ecJwk);
        PublicKey pub = sut.toPublicKey();
        Assert.assertNotNull((Object)pub);
        Assert.assertTrue((boolean)pub.getAlgorithm().startsWith("EC"));
        Assert.assertEquals((Object)"X.509", (Object)pub.getFormat());
    }

    private byte[] sign(byte[] data, String javaAlgorithm, PrivateKey key) throws Exception {
        Signature signature = Signature.getInstance(javaAlgorithm);
        signature.initSign(key);
        signature.update(data);
        return signature.sign();
    }

    private boolean verify(byte[] data, byte[] signature, String javaAlgorithm, PublicKey key) throws Exception {
        Signature verifier = Signature.getInstance(javaAlgorithm);
        verifier.initVerify(key);
        verifier.update(data);
        return verifier.verify(signature);
    }
}

