/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rule;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunInThreadRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Statement result = base;
        result = new RunInThreadStatement(base);
        return result;
    }

    private static class RunInThreadStatement
    extends Statement {
        private final Statement baseStatement;
        private Future<?> future;
        private volatile Throwable throwable;

        RunInThreadStatement(Statement baseStatement) {
            this.baseStatement = baseStatement;
        }

        public void evaluate() throws Throwable {
            ExecutorService executorService = this.runInThread();
            try {
                this.waitTillFinished();
            }
            finally {
                executorService.shutdown();
            }
            this.rethrowAssertionsAndErrors();
        }

        private ExecutorService runInThread() {
            ExecutorService result = Executors.newSingleThreadExecutor();
            this.future = result.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        baseStatement.evaluate();
                    }
                    catch (Throwable throwable) {
                        throwable = throwable;
                    }
                }
            });
            return result;
        }

        private void waitTillFinished() {
            try {
                this.future.get();
            }
            catch (ExecutionException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
            catch (InterruptedException shouldNotHappen) {
                throw new IllegalStateException(shouldNotHappen);
            }
        }

        private void rethrowAssertionsAndErrors() throws Throwable {
            if (this.throwable != null) {
                throw this.throwable;
            }
        }
    }
}

