/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.VisibleSdJwtClaim;

public class IssuerSignedJWTTest {
    @Test
    public void testIssuerSignedJWTPayloadWithValidClaims() {
        JsonNode claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-holder-claims.json");
        ArrayList claims = new ArrayList();
        claimSet.fields().forEachRemaining(entry -> claims.add(VisibleSdJwtClaim.builder().withClaimName((String)entry.getKey()).withClaimValue((JsonNode)entry.getValue()).build()));
        IssuerSignedJWT jwt = IssuerSignedJWT.builder().withClaims(claims).build();
        Assert.assertEquals((Object)claimSet, (Object)jwt.getPayload());
    }

    @Test
    public void testIssuerSignedJWTPayloadThrowsExceptionForDuplicateClaims() throws IOException {
        JsonNode claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-holder-claims.json");
        ArrayList claims = new ArrayList();
        claimSet.fields().forEachRemaining(entry -> claims.add(VisibleSdJwtClaim.builder().withClaimName((String)entry.getKey()).withClaimValue((JsonNode)entry.getValue()).build()));
        claimSet.fields().forEachRemaining(entry -> claims.add(VisibleSdJwtClaim.builder().withClaimName((String)entry.getKey()).withClaimValue((JsonNode)entry.getValue()).build()));
        Assert.assertTrue((claims.size() == claimSet.size() * 2 ? 1 : 0) != 0);
        Assert.assertThrows(IllegalArgumentException.class, () -> IssuerSignedJWT.builder().withClaims(claims).build());
    }

    @Test
    public void testIssuerSignedJWTWithUndiclosedClaims6_1() {
        JsonNode claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-holder-claims.json");
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("email", "JnwGqRFZjMprsoZobherdQ").withUndisclosedClaim("phone_number", "ffZ03jm_zeHyG4-yoNt6vg").withUndisclosedClaim("address", "INhOGJnu82BAtsOwiCJc_A").withUndisclosedClaim("birthdate", "d0l3jsh5sBzj2oEhZxrJGw").build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(claimSet).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s6.1-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }

    @Test
    public void testIssuerSignedJWTWithUndiclosedClaims3_3() {
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("given_name", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("family_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("email", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("phone_number", "eI8ZWm9QnKPpNPeNenHdhQ").withUndisclosedClaim("address", "Qg_O64zqAxe412a108iroA").withUndisclosedClaim("birthdate", "AJx-095VPrpTtN4QMOqROA").withUndisclosedClaim("is_over_18", "Pc33JM2LchcU_lHggv_ufQ").withUndisclosedClaim("is_over_21", "G02NSrQfjFXQ7Io09syajA").withUndisclosedClaim("is_over_65", "lklxF5jMYlGTPUovMNIvCA").build();
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s3.3-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }
}

