/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.consumer.SimplePresentationDefinition;

public class SimplePresentationDefinitionTest {
    private final ObjectMapper mapper = SdJwtUtils.mapper;

    @Test
    public void testCheckIfSatisfiedBy() throws VerificationException, JsonProcessingException {
        SimplePresentationDefinition definition = SimplePresentationDefinition.builder().addClaimRequirement("vct", ".*identity_credential.*").addClaimRequirement("given_name", "\"John\"").addClaimRequirement("cat", "123").addClaimRequirement("addr", ".*\"(Douala|Berlin)\".*").addClaimRequirement("colors", "\\[\"red\",.*").build();
        definition.checkIfSatisfiedBy(this.exampleDisclosedPayload());
    }

    @Test
    public void testCheckIfSatisfiedBy_shouldFailOnRequiredFieldMissing() {
        SimplePresentationDefinition definition = SimplePresentationDefinition.builder().addClaimRequirement("family_name", ".*").build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> definition.checkIfSatisfiedBy(this.exampleDisclosedPayload()));
        Assert.assertEquals((Object)"A required field was not presented: `family_name`", (Object)exception.getMessage());
    }

    @Test
    public void testCheckIfSatisfiedBy_shouldFailOnNonMatchingPattern() {
        SimplePresentationDefinition definition = SimplePresentationDefinition.builder().addClaimRequirement("vct", ".*diploma.*").build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> definition.checkIfSatisfiedBy(this.exampleDisclosedPayload()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Pattern matching failed for required field"));
    }

    private JsonNode exampleDisclosedPayload() throws JsonProcessingException {
        String content = TestUtils.readFileAsString(this.getClass(), "sdjwt/s7.4-sample-disclosed-issuer-payload.json");
        return this.mapper.readTree(content);
    }
}

