/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestSettings;
import org.keycloak.sdjwt.TestUtils;

public class SdJwtTest {
    @Test
    public void settingsTest() {
        SignatureSignerContext issuerSignerContext = TestSettings.getInstance().getIssuerSignerContext();
        Assert.assertNotNull((Object)issuerSignerContext);
    }

    @Test
    public void testA1_Example2_with_nested_disclosure_and_decoy_claims() {
        DisclosureSpec addrDisclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("street_address", "AJx-095VPrpTtN4QMOqROA").withUndisclosedClaim("locality", "Pc33JM2LchcU_lHggv_ufQ").withUndisclosedClaim("region", "G02NSrQfjFXQ7Io09syajA").withUndisclosedClaim("country", "lklxF5jMYlGTPUovMNIvCA").withDecoyClaim("2GLC42sKQveCfGfryNRN9w").withDecoyClaim("eluV5Og3gSNII8EYnsxA_A").withDecoyClaim("6Ij7tM-a5iVPGboS5tmvVA").withDecoyClaim("eI8ZWm9QnKPpNPeNenHdhQ").build();
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("sub", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("email", "eI8ZWm9QnKPpNPeNenHdhQ").withUndisclosedClaim("phone_number", "Qg_O64zqAxe412a108iroA").withUndisclosedClaim("birthdate", "yytVbdAPGcgl2rI4C9GSog").withDecoyClaim("AJx-095VPrpTtN4QMOqROA").withDecoyClaim("G02NSrQfjFXQ7Io09syajA").build();
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-holder-claims.json");
        JsonNode addressClaimSet = holderClaimSet.get("address");
        SdJwt addrSdJWT = SdJwt.builder().withDisclosureSpec(addrDisclosureSpec).withClaimSet(addressClaimSet).build();
        JsonNode addPayload = addrSdJWT.asNestedPayload();
        JsonNode expectedAddrPayload = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-address-payload.json");
        Assert.assertEquals((Object)expectedAddrPayload, (Object)addPayload);
        Assert.assertEquals((long)4L, (long)addrSdJWT.getDisclosures().size());
        ((ObjectNode)holderClaimSet).set("address", addPayload);
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).withNestedSdJwt(addrSdJWT).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
        Assert.assertEquals((long)10L, (long)sdJwt.getDisclosures().size());
    }
}

