/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.crypto.ECDSASignatureSignerContext;
import org.keycloak.crypto.ECDSASignatureVerifierContext;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.sdjwt.TestUtils;

public class TestSettings {
    public final SignatureSignerContext holderSigContext;
    public final SignatureSignerContext issuerSigContext;
    public final SignatureVerifierContext holderVerifierContext;
    public final SignatureVerifierContext issuerVerifierContext;
    private static TestSettings instance = null;
    private static final Map<String, ECParameterSpec> ECDSA_KEY_SPECS = new HashMap<String, ECParameterSpec>();
    private static final Map<String, String> ECDSA_CURVE_2_SPECS_NAMES = new HashMap<String, String>();

    public static TestSettings getInstance() {
        if (instance == null) {
            instance = new TestSettings();
        }
        return instance;
    }

    public SignatureSignerContext getIssuerSignerContext() {
        return this.issuerSigContext;
    }

    public SignatureSignerContext getHolderSignerContext() {
        return this.holderSigContext;
    }

    public SignatureVerifierContext getIssuerVerifierContext() {
        return this.issuerVerifierContext;
    }

    public SignatureVerifierContext getHolderVerifierContext() {
        return this.holderVerifierContext;
    }

    private TestSettings() {
        JsonNode testSettings = TestUtils.readClaimSet(this.getClass(), "sdjwt/test-settings.json");
        JsonNode keySettings = testSettings.get("key_settings");
        this.holderSigContext = TestSettings.initSigContext(keySettings, "holder_key", "ES256", "holder");
        this.issuerSigContext = TestSettings.initSigContext(keySettings, "issuer_key", "ES256", "doc-signer-05-25-2022");
        this.holderVerifierContext = TestSettings.initVerifierContext(keySettings, "holder_key", "ES256", "holder");
        this.issuerVerifierContext = TestSettings.initVerifierContext(keySettings, "issuer_key", "ES256", "doc-signer-05-25-2022");
    }

    private static SignatureSignerContext initSigContext(JsonNode keySettings, String keyName, String algorithm, String kid) {
        JsonNode keySetting = keySettings.get(keyName);
        KeyPair keyPair = TestSettings.readKeyPair(keySetting);
        return TestSettings.getSignatureSignerContext(keyPair, algorithm, kid);
    }

    private static SignatureVerifierContext initVerifierContext(JsonNode keySettings, String keyName, String algorithm, String kid) {
        JsonNode keySetting = keySettings.get(keyName);
        KeyPair keyPair = TestSettings.readKeyPair(keySetting);
        return TestSettings.getSignatureVerifierContext(keyPair.getPublic(), algorithm, kid);
    }

    private static KeyPair readKeyPair(JsonNode keySetting) {
        String curveName = keySetting.get("crv").asText();
        String base64UrlEncodedD = keySetting.get("d").asText();
        String base64UrlEncodedX = keySetting.get("x").asText();
        String base64UrlEncodedY = keySetting.get("y").asText();
        return TestSettings.readEcdsaKeyPair(curveName, base64UrlEncodedD, base64UrlEncodedX, base64UrlEncodedY);
    }

    public static SignatureVerifierContext verifierContextFrom(JsonNode keyData, String algorithm) {
        PublicKey publicKey = TestSettings.readPublicKey(keyData);
        return TestSettings.getSignatureVerifierContext(publicKey, algorithm, KeyUtils.createKeyId((Key)publicKey));
    }

    private static PublicKey readPublicKey(JsonNode keyData) {
        if (keyData.has("jwk")) {
            keyData = keyData.get("jwk");
        }
        String curveName = keyData.get("crv").asText();
        String base64UrlEncodedX = keyData.get("x").asText();
        String base64UrlEncodedY = keyData.get("y").asText();
        return TestSettings.readEcdsaPublic(curveName, base64UrlEncodedX, base64UrlEncodedY);
    }

    private static PublicKey readEcdsaPublic(String curveName, String base64UrlEncodedX, String base64UrlEncodedY) {
        ECParameterSpec ecSpec = TestSettings.getECParameterSpec(ECDSA_CURVE_2_SPECS_NAMES.get(curveName));
        byte[] xBytes = Base64Url.decode((String)base64UrlEncodedX);
        byte[] yBytes = Base64Url.decode((String)base64UrlEncodedY);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            BigInteger xValue = new BigInteger(1, xBytes);
            BigInteger yValue = new BigInteger(1, yBytes);
            ECPoint point = new ECPoint(xValue, yValue);
            return keyFactory.generatePublic(new ECPublicKeySpec(point, ecSpec));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyPair readEcdsaKeyPair(String curveName, String base64UrlEncodedD, String base64UrlEncodedX, String base64UrlEncodedY) {
        ECParameterSpec ecSpec = TestSettings.getECParameterSpec(ECDSA_CURVE_2_SPECS_NAMES.get(curveName));
        byte[] dBytes = Base64Url.decode((String)base64UrlEncodedD);
        byte[] xBytes = Base64Url.decode((String)base64UrlEncodedX);
        byte[] yBytes = Base64Url.decode((String)base64UrlEncodedY);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            BigInteger dValue = new BigInteger(1, dBytes);
            PrivateKey privateKey = keyFactory.generatePrivate(new ECPrivateKeySpec(dValue, ecSpec));
            BigInteger xValue = new BigInteger(1, xBytes);
            BigInteger yValue = new BigInteger(1, yBytes);
            ECPoint point = new ECPoint(xValue, yValue);
            PublicKey publicKey = keyFactory.generatePublic(new ECPublicKeySpec(point, ecSpec));
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ECParameterSpec getECParameterSpec(String paramSpecName) {
        return ECDSA_KEY_SPECS.computeIfAbsent(paramSpecName, TestSettings::generateEcdsaKeySpec);
    }

    private static ECParameterSpec generateEcdsaKeySpec(String paramSpecName) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(paramSpecName);
            keyPairGenerator.initialize(ecGenParameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return ((ECPublicKey)keyPair.getPublic()).getParams();
        }
        catch (Exception e) {
            throw new RuntimeException("Error obtaining ECParameterSpec for P-256 curve", e);
        }
    }

    private static SignatureSignerContext getSignatureSignerContext(KeyPair keyPair, String algorithm, String kid) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setAlgorithm(algorithm);
        keyWrapper.setPrivateKey((Key)keyPair.getPrivate());
        keyWrapper.setPublicKey((Key)keyPair.getPublic());
        keyWrapper.setType(keyPair.getPublic().getAlgorithm());
        keyWrapper.setUse(KeyUse.SIG);
        keyWrapper.setKid(kid);
        return new ECDSASignatureSignerContext(keyWrapper);
    }

    private static SignatureVerifierContext getSignatureVerifierContext(PublicKey publicKey, String algorithm, String kid) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setAlgorithm(algorithm);
        keyWrapper.setPublicKey((Key)publicKey);
        keyWrapper.setType(publicKey.getAlgorithm());
        keyWrapper.setUse(KeyUse.SIG);
        keyWrapper.setKid(kid);
        return new ECDSASignatureVerifierContext(keyWrapper);
    }

    private static final void curveToSpecName() {
        ECDSA_CURVE_2_SPECS_NAMES.put("P-256", "secp256r1");
    }

    static {
        TestSettings.curveToSpecName();
    }
}

