/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.util.Time;
import org.keycloak.json.StringOrArrayDeserializer;
import org.keycloak.json.StringOrArraySerializer;

public class JsonWebToken
implements Serializable {
    @JsonProperty(value="jti")
    protected String id;
    @JsonProperty(value="exp")
    protected int expiration;
    @JsonProperty(value="nbf")
    protected int notBefore;
    @JsonProperty(value="iat")
    protected int issuedAt;
    @JsonProperty(value="iss")
    protected String issuer;
    @JsonProperty(value="aud")
    @JsonSerialize(using=StringOrArraySerializer.class)
    @JsonDeserialize(using=StringOrArrayDeserializer.class)
    protected String[] audience;
    @JsonProperty(value="sub")
    protected String subject;
    @JsonProperty(value="typ")
    protected String type;
    @JsonProperty(value="azp")
    public String issuedFor;
    protected Map<String, Object> otherClaims = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public JsonWebToken id(String id) {
        this.id = id;
        return this;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public JsonWebToken expiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    @JsonIgnore
    public boolean isExpired() {
        return Time.currentTime() > this.expiration;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public JsonWebToken notBefore(int notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    @JsonIgnore
    public boolean isNotBefore() {
        return Time.currentTime() >= this.notBefore;
    }

    @JsonIgnore
    public boolean isActive() {
        return !(this.isExpired() && this.expiration != 0 || !this.isNotBefore() && this.notBefore != 0);
    }

    public int getIssuedAt() {
        return this.issuedAt;
    }

    @JsonIgnore
    public JsonWebToken issuedNow() {
        this.issuedAt = Time.currentTime();
        return this;
    }

    public JsonWebToken issuedAt(int issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JsonWebToken issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @JsonIgnore
    public String[] getAudience() {
        return this.audience;
    }

    public boolean hasAudience(String audience) {
        for (String a : this.audience) {
            if (!a.equals(audience)) continue;
            return true;
        }
        return false;
    }

    public JsonWebToken audience(String ... audience) {
        this.audience = audience;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JsonWebToken subject(String subject) {
        this.subject = subject;
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getType() {
        return this.type;
    }

    public JsonWebToken type(String type) {
        this.type = type;
        return this;
    }

    public String getIssuedFor() {
        return this.issuedFor;
    }

    public JsonWebToken issuedFor(String issuedFor) {
        this.issuedFor = issuedFor;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonAnySetter
    public void setOtherClaims(String name, Object value) {
        this.otherClaims.put(name, value);
    }
}

