/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe.enc;

import org.keycloak.jose.jwe.enc.AesCbcHmacShaEncryptionProvider;

public class AesCbcHmacShaJWEEncryptionProvider
extends AesCbcHmacShaEncryptionProvider {
    private final int expectedCEKLength;
    private final int expectedAesKeyLength;
    private final String hmacShaAlgorithm;
    private final int authenticationTagLength;

    public AesCbcHmacShaJWEEncryptionProvider(String jwaAlgorithmName) {
        if ("A128CBC-HS256".equals(jwaAlgorithmName)) {
            this.expectedCEKLength = 32;
            this.expectedAesKeyLength = 16;
            this.hmacShaAlgorithm = "HMACSHA256";
            this.authenticationTagLength = 16;
        } else {
            this.expectedCEKLength = 0;
            this.expectedAesKeyLength = 0;
            this.hmacShaAlgorithm = null;
            this.authenticationTagLength = 0;
        }
    }

    @Override
    public int getExpectedCEKLength() {
        return this.expectedCEKLength;
    }

    @Override
    protected int getExpectedAesKeyLength() {
        return this.expectedAesKeyLength;
    }

    @Override
    protected String getHmacShaAlgorithm() {
        return this.hmacShaAlgorithm;
    }

    @Override
    protected int getAuthenticationTagLength() {
        return this.authenticationTagLength;
    }
}

