/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.security.Security;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.crypto.fips.BCFIPSCertificateUtilsProvider;
import org.keycloak.crypto.fips.BCFIPSPemUtilsProvider;
import org.keycloak.crypto.fips.FIPSAesKeyWrapAlgorithmProvider;
import org.keycloak.crypto.fips.KeycloakFipsSecurityProvider;

public class FIPS1402Provider
implements CryptoProvider {
    private final Map<String, Object> providers = new ConcurrentHashMap<String, Object>();

    public FIPS1402Provider() {
        BouncyCastleFipsProvider bcFipsProvider = new BouncyCastleFipsProvider();
        this.providers.put("bc-provider", bcFipsProvider);
        this.providers.put("aes-keywrap-alg", new FIPSAesKeyWrapAlgorithmProvider());
        Security.insertProviderAt(new KeycloakFipsSecurityProvider(bcFipsProvider), 1);
    }

    public <T> T getAlgorithmProvider(Class<T> clazz, String algorithm) {
        Object o = this.providers.get(algorithm);
        if (o == null) {
            throw new IllegalArgumentException("Not found provider of algorithm: " + algorithm);
        }
        return clazz.cast(o);
    }

    public CertificateUtilsProvider getCertificateUtils() {
        return new BCFIPSCertificateUtilsProvider();
    }

    public PemUtilsProvider getPemUtils() {
        return new BCFIPSPemUtilsProvider();
    }

    public ECParameterSpec createECParams(String curveName) {
        ECField field;
        X9ECParameters params = ECNamedCurveTable.getByName((String)curveName);
        ECCurve ecCurve = params.getCurve();
        if (ecCurve instanceof ECCurve.F2m) {
            ECCurve.F2m f2m = (ECCurve.F2m)ecCurve;
            field = new ECFieldF2m(f2m.getM(), new int[]{f2m.getK1(), f2m.getK2(), f2m.getK3()});
        } else if (ecCurve instanceof ECCurve.Fp) {
            ECCurve.Fp fp = (ECCurve.Fp)ecCurve;
            field = new ECFieldFp(fp.getQ());
        } else {
            throw new RuntimeException("Unsupported curve");
        }
        EllipticCurve c = new EllipticCurve(field, ecCurve.getA().toBigInteger(), ecCurve.getB().toBigInteger(), params.getSeed());
        ECPoint point = new ECPoint(params.getG().getXCoord().toBigInteger(), params.getG().getYCoord().toBigInteger());
        return new ECParameterSpec(c, point, params.getN(), params.getH().intValue());
    }
}

