/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.util.KeycloakUriBuilder;

public class KeycloakDeployment {
    private static final Logger log = Logger.getLogger(KeycloakDeployment.class);
    protected boolean relativeUrls;
    protected String realm;
    protected PublicKey realmKey;
    protected KeycloakUriBuilder serverBuilder;
    protected String authServerBaseUrl;
    protected String realmInfoUrl;
    protected KeycloakUriBuilder authUrl;
    protected String codeUrl;
    protected String refreshUrl;
    protected KeycloakUriBuilder logoutUrl;
    protected String accountUrl;
    protected String resourceName;
    protected boolean bearerOnly;
    protected boolean publicClient;
    protected Map<String, String> resourceCredentials = new HashMap<String, String>();
    protected HttpClient client;
    protected String scope;
    protected boolean sslRequired = true;
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected boolean useResourceRoleMappings;
    protected boolean cors;
    protected int corsMaxAge = -1;
    protected String corsAllowedHeaders;
    protected String corsAllowedMethods;
    protected boolean exposeToken;
    protected volatile int notBefore;

    public boolean isConfigured() {
        return this.getRealm() != null && this.getRealmKey() != null && (this.isBearerOnly() || this.getAuthServerBaseUrl() != null);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public PublicKey getRealmKey() {
        return this.realmKey;
    }

    public void setRealmKey(PublicKey realmKey) {
        this.realmKey = realmKey;
    }

    public String getAuthServerBaseUrl() {
        return this.authServerBaseUrl;
    }

    public void setAuthServerBaseUrl(String authServerBaseUrl) {
        this.authServerBaseUrl = authServerBaseUrl;
        if (authServerBaseUrl == null) {
            return;
        }
        URI uri = URI.create(authServerBaseUrl);
        if (uri.getHost() == null) {
            this.relativeUrls = true;
            return;
        }
        this.relativeUrls = false;
        this.serverBuilder = KeycloakUriBuilder.fromUri((String)authServerBaseUrl);
        String login = this.serverBuilder.clone().path("/realms/{realm-name}/tokens/login").build(new Object[]{this.getRealm()}).toString();
        this.authUrl = KeycloakUriBuilder.fromUri((String)login);
        this.refreshUrl = this.serverBuilder.clone().path("/realms/{realm-name}/tokens/refresh").build(new Object[]{this.getRealm()}).toString();
        this.logoutUrl = KeycloakUriBuilder.fromUri((String)this.serverBuilder.clone().path("/realms/{realm-name}/tokens/logout").build(new Object[]{this.getRealm()}).toString());
        this.accountUrl = this.serverBuilder.clone().path("/realms/{realm-name}/account").build(new Object[]{this.getRealm()}).toString();
        this.realmInfoUrl = this.serverBuilder.clone().path("/realms/{realm-name}").build(new Object[]{this.getRealm()}).toString();
        this.codeUrl = this.serverBuilder.clone().path("/realms/{realm-name}/tokens/access/codes").build(new Object[]{this.getRealm()}).toString();
    }

    public String getRealmInfoUrl() {
        return this.realmInfoUrl;
    }

    public KeycloakUriBuilder getAuthUrl() {
        return this.authUrl;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public KeycloakUriBuilder getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getAccountUrl() {
        return this.accountUrl;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public void setBearerOnly(boolean bearerOnly) {
        this.bearerOnly = bearerOnly;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public Map<String, String> getResourceCredentials() {
        return this.resourceCredentials;
    }

    public void setResourceCredentials(Map<String, String> resourceCredentials) {
        this.resourceCredentials = resourceCredentials;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public boolean isUseResourceRoleMappings() {
        return this.useResourceRoleMappings;
    }

    public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public boolean isCors() {
        return this.cors;
    }

    public void setCors(boolean cors) {
        this.cors = cors;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public boolean isExposeToken() {
        return this.exposeToken;
    }

    public void setExposeToken(boolean exposeToken) {
        this.exposeToken = exposeToken;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }
}

