/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

public abstract class RequestAuthenticator {
    protected static Logger log = Logger.getLogger(RequestAuthenticator.class);
    protected HttpFacade facade;
    protected KeycloakDeployment deployment;
    protected AuthChallenge challenge;
    protected int sslRedirectPort;

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort) {
        this.facade = facade;
        this.deployment = deployment;
        this.sslRedirectPort = sslRedirectPort;
    }

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment) {
        this.facade = facade;
        this.deployment = deployment;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public AuthOutcome authenticate() {
        log.info((Object)"--> authenticate()");
        BearerTokenRequestAuthenticator bearer = this.createBearerTokenAuthenticator();
        log.info((Object)"try bearer");
        AuthOutcome outcome = bearer.authenticate(this.facade);
        if (outcome == AuthOutcome.FAILED) {
            this.challenge = bearer.getChallenge();
            log.info((Object)"Bearer FAILED");
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            this.completeAuthentication(bearer);
            log.info((Object)"Bearer AUTHENTICATED");
            return AuthOutcome.AUTHENTICATED;
        }
        if (this.deployment.isBearerOnly()) {
            this.challenge = bearer.getChallenge();
            log.info((Object)"NOT_ATTEMPTED: bearer only");
            return AuthOutcome.NOT_ATTEMPTED;
        }
        log.info((Object)"try oauth");
        if (this.isCached()) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            log.info((Object)"AUTHENTICATED: was cached");
            return AuthOutcome.AUTHENTICATED;
        }
        OAuthRequestAuthenticator oauth = this.createOAuthAuthenticator();
        outcome = oauth.authenticate();
        if (outcome == AuthOutcome.FAILED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.NOT_ATTEMPTED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.verifySSL()) {
            return AuthOutcome.FAILED;
        }
        this.completeAuthentication(oauth);
        this.facade.getResponse().setHeader("Location", oauth.getStrippedOauthParametersRequestUri());
        this.facade.getResponse().setStatus(302);
        this.facade.getResponse().end();
        log.info((Object)"AUTHENTICATED");
        return AuthOutcome.AUTHENTICATED;
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.warn((Object)"SSL is required to authenticate");
            return true;
        }
        return false;
    }

    protected abstract OAuthRequestAuthenticator createOAuthAuthenticator();

    protected BearerTokenRequestAuthenticator createBearerTokenAuthenticator() {
        return new BearerTokenRequestAuthenticator(this.deployment);
    }

    protected void completeAuthentication(OAuthRequestAuthenticator oauth) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, oauth.getTokenString(), oauth.getToken(), oauth.getIdTokenString(), oauth.getIdToken(), oauth.getRefreshToken());
        KeycloakPrincipal principal = new KeycloakPrincipal(oauth.getToken().getSubject(), (KeycloakSecurityContext)session);
        this.completeOAuthAuthentication(principal, session);
    }

    protected abstract void completeOAuthAuthentication(KeycloakPrincipal var1, RefreshableKeycloakSecurityContext var2);

    protected abstract void completeBearerAuthentication(KeycloakPrincipal var1, RefreshableKeycloakSecurityContext var2);

    protected abstract boolean isCached();

    protected void completeAuthentication(BearerTokenRequestAuthenticator bearer) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, bearer.getTokenString(), bearer.getToken(), null, null, null);
        KeycloakPrincipal principal = new KeycloakPrincipal(bearer.getToken().getSubject(), (KeycloakSecurityContext)session);
        this.completeBearerAuthentication(principal, session);
    }
}

