/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.keycloak.subsystem.extension.KeycloakExtension;
import org.keycloak.subsystem.extension.RealmAddHandler;
import org.keycloak.subsystem.extension.RealmRemoveHandler;
import org.keycloak.subsystem.extension.RealmWriteAttributeHandler;
import org.keycloak.subsystem.extension.SharedAttributeDefinitons;

public class RealmDefinition
extends SimpleResourceDefinition {
    public static final String TAG_NAME = "realm";
    protected static final List<SimpleAttributeDefinition> REALM_ONLY_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    protected static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    private static final Map<String, SimpleAttributeDefinition> DEFINITION_LOOKUP;
    private static final RealmWriteAttributeHandler realmAttrHandler;

    public RealmDefinition() {
        super(PathElement.pathElement((String)TAG_NAME), (ResourceDescriptionResolver)KeycloakExtension.getResourceDescriptionResolver(TAG_NAME), (OperationStepHandler)RealmAddHandler.INSTANCE, (OperationStepHandler)RealmRemoveHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)realmAttrHandler);
        }
    }

    public static SimpleAttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    static {
        ALL_ATTRIBUTES.addAll(REALM_ONLY_ATTRIBUTES);
        ALL_ATTRIBUTES.addAll(SharedAttributeDefinitons.ATTRIBUTES);
        DEFINITION_LOOKUP = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
        realmAttrHandler = new RealmWriteAttributeHandler((AttributeDefinition[])ALL_ATTRIBUTES.toArray(new SimpleAttributeDefinition[0]));
    }
}

