/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.extension.KeycloakExtension;
import org.keycloak.subsystem.extension.authserver.AddProviderHandler;
import org.keycloak.subsystem.extension.authserver.AuthServerAddHandler;
import org.keycloak.subsystem.extension.authserver.AuthServerRemoveHandler;
import org.keycloak.subsystem.extension.authserver.AuthServerWriteAttributeHandler;
import org.keycloak.subsystem.extension.authserver.ListOverlaysHandler;
import org.keycloak.subsystem.extension.authserver.OverlayKeycloakServerJsonHandler;
import org.keycloak.subsystem.extension.authserver.RemoveOverlayHandler;

public class AuthServerDefinition
extends SimpleResourceDefinition {
    public static final String TAG_NAME = "auth-server";
    protected static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setXmlName("enabled")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition WEB_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("web-context", ModelType.STRING, true).setXmlName("web-context")).setAllowExpression(true)).setDefaultValue(new ModelNode("auth"))).setValidator((ParameterValidator)new WebContextValidator())).setRestartAllServices()).build();
    protected static final ResourceDescriptionResolver rscDescriptionResolver = KeycloakExtension.getResourceDescriptionResolver("auth-server");
    public static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    private static final Map<String, SimpleAttributeDefinition> DEFINITION_LOOKUP;
    private static AuthServerWriteAttributeHandler attrHandler;

    public AuthServerDefinition() {
        super(PathElement.pathElement((String)TAG_NAME), rscDescriptionResolver, (OperationStepHandler)AuthServerAddHandler.INSTANCE, (OperationStepHandler)AuthServerRemoveHandler.INSTANCE, null, OperationEntry.Flag.RESTART_ALL_SERVICES);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(AddProviderHandler.DEFINITION, (OperationStepHandler)AddProviderHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(OverlayKeycloakServerJsonHandler.DEFINITION, (OperationStepHandler)OverlayKeycloakServerJsonHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(ListOverlaysHandler.DEFINITION, ListOverlaysHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(RemoveOverlayHandler.DEFINITION, RemoveOverlayHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)attrHandler);
        }
    }

    public static SimpleAttributeDefinition lookup(String name) {
        return DEFINITION_LOOKUP.get(name);
    }

    static {
        ALL_ATTRIBUTES.add(ENABLED);
        ALL_ATTRIBUTES.add(WEB_CONTEXT);
        DEFINITION_LOOKUP = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            DEFINITION_LOOKUP.put(def.getXmlName(), def);
        }
        attrHandler = new AuthServerWriteAttributeHandler(ALL_ATTRIBUTES);
    }

    private static class WebContextValidator
    implements ParameterValidator {
        private WebContextValidator() {
        }

        public void validateParameter(String paramName, ModelNode value) throws OperationFailedException {
            String strValue = value.asString();
            if (KeycloakAdapterConfigService.INSTANCE.isWebContextUsed(strValue)) {
                throw new OperationFailedException("Can not set web-context to '" + strValue + "'. web-context must be unique among all deployments.");
            }
        }

        public void validateResolvedParameter(String paramName, ModelNode value) throws OperationFailedException {
            String strValue = value.asString();
            if (KeycloakAdapterConfigService.INSTANCE.isWebContextUsed(strValue)) {
                throw new OperationFailedException("Can not set web-context to '" + strValue + "'. web-context must be unique among all deployments.");
            }
        }
    }
}

