/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class AuthServerUtil {
    private static final ModuleIdentifier KEYCLOAK_SUBSYSTEM = ModuleIdentifier.create((String)"org.keycloak.keycloak-subsystem");
    private final String deploymentName;
    private final Module subsysModule;
    private final String keycloakVersion;
    private final boolean isAuthServerExploded;
    private final URI authServerUri;

    AuthServerUtil(ModelNode operation) {
        this.deploymentName = AuthServerUtil.getDeploymentName(operation);
        this.subsysModule = this.findSubsysModule();
        this.keycloakVersion = this.subsysModule.getProperty("keycloak-version");
        this.isAuthServerExploded = Boolean.parseBoolean(this.subsysModule.getProperty("auth-server-exploded"));
        this.authServerUri = this.findAuthServerUri();
    }

    String getDeploymentName() {
        return this.deploymentName;
    }

    private Module findSubsysModule() {
        try {
            return Module.getModuleFromCallerModuleLoader((ModuleIdentifier)KEYCLOAK_SUBSYSTEM);
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException("Can't find Keycloak subsystem.", e);
        }
    }

    private URI findAuthServerUri() throws IllegalStateException {
        try {
            URL subsysJar = this.subsysModule.getExportedResource("keycloak-subsystem-" + this.keycloakVersion + ".jar");
            File subsysDir = new File(subsysJar.toURI()).getParentFile();
            File authServerDir = new File(subsysDir, "auth-server");
            if (this.isAuthServerExploded) {
                return authServerDir.toURI();
            }
            return new File(authServerDir, "keycloak-server-" + this.keycloakVersion + ".war").toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    void addStepToUploadAuthServer(OperationContext context, boolean isEnabled) throws OperationFailedException {
        PathAddress deploymentAddress = AuthServerUtil.deploymentAddress(this.deploymentName);
        ModelNode op = Util.createOperation((String)"add", (PathAddress)deploymentAddress);
        op.get("enabled").set(isEnabled);
        op.get("persistent").set(false);
        if (this.authServerUri == null) {
            throw new OperationFailedException("Keycloak Auth Server WAR not found in keycloak-subsystem module");
        }
        op.get("content").add(this.makeContentItem());
        context.addStep(op, AuthServerUtil.getHandler(context, deploymentAddress, "add"), OperationContext.Stage.MODEL);
    }

    private ModelNode makeContentItem() throws OperationFailedException {
        ModelNode contentItem = new ModelNode();
        if (this.isAuthServerExploded) {
            String urlString = new File(this.authServerUri).getAbsolutePath();
            contentItem.get("path").set(urlString);
            contentItem.get("archive").set(false);
        } else {
            String urlString = this.authServerUri.toString();
            contentItem.get("url").set(urlString);
        }
        return contentItem;
    }

    static void addStepToRedeployAuthServer(OperationContext context, String deploymentName) {
        AuthServerUtil.addDeploymentAction(context, "redeploy", deploymentName);
    }

    static void addStepToUndeployAuthServer(OperationContext context, String deploymentName) {
        AuthServerUtil.addDeploymentAction(context, "undeploy", deploymentName);
    }

    static void addStepToDeployAuthServer(OperationContext context, String deploymentName) {
        AuthServerUtil.addDeploymentAction(context, "deploy", deploymentName);
    }

    private static void addDeploymentAction(OperationContext context, String operation, String deploymentName) {
        if (!context.isNormalServer()) {
            return;
        }
        PathAddress deploymentAddress = AuthServerUtil.deploymentAddress(deploymentName);
        ModelNode op = Util.createOperation((String)operation, (PathAddress)deploymentAddress);
        op.get("runtime-name").set(deploymentName);
        context.addStep(op, AuthServerUtil.getHandler(context, deploymentAddress, operation), OperationContext.Stage.MODEL);
    }

    private static PathAddress deploymentAddress(String deploymentName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deploymentName)});
    }

    static OperationStepHandler getHandler(OperationContext context, PathAddress address, String opName) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        return rootResourceRegistration.getOperationHandler(address, opName);
    }

    static String getDeploymentName(ModelNode operation) {
        String deploymentName = Util.getNameFromAddress((ModelNode)operation.get("address"));
        if (!deploymentName.toLowerCase().endsWith(".war")) {
            deploymentName = deploymentName + ".war";
        }
        return deploymentName;
    }

    static String getAuthServerName(ModelNode operation) {
        PathAddress pathAddr = AuthServerUtil.getPathAddress(operation);
        return pathAddr.getElement(pathAddr.size() - 1).getValue();
    }

    static PathAddress getPathAddress(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    static PathAddress getOverlayAddress(String overlayName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)overlayName)});
    }

    static String getOverlayName(ModelNode operation) {
        return AuthServerUtil.getAuthServerName(operation) + "-keycloak-overlay";
    }

    static boolean isOverlayExists(OperationContext context, String overlayName, PathAddress address) {
        Resource resource = context.readResourceFromRoot(address);
        return resource.getChildrenNames("deployment-overlay").contains(overlayName);
    }
}

