/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;

public class WritableLDAPUserModelDelegate
extends UserModelDelegate
implements UserModel {
    private static final Logger logger = Logger.getLogger(WritableLDAPUserModelDelegate.class);
    protected LDAPFederationProvider provider;

    public WritableLDAPUserModelDelegate(UserModel delegate, LDAPFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        IdentityManager identityManager = this.provider.getIdentityManager();
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)this.delegate.getUsername());
            if (picketlinkUser == null) {
                throw new IllegalStateException("User not found in LDAP storage!");
            }
            picketlinkUser.setLoginName(username);
            identityManager.update((AttributedType)picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw new ModelException((Throwable)ie);
        }
        this.delegate.setUsername(username);
    }

    public void setLastName(String lastName) {
        IdentityManager identityManager = this.provider.getIdentityManager();
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)this.delegate.getUsername());
            if (picketlinkUser == null) {
                throw new IllegalStateException("User not found in LDAP storage!");
            }
            picketlinkUser.setLastName(lastName);
            identityManager.update((AttributedType)picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw new ModelException((Throwable)ie);
        }
        this.delegate.setLastName(lastName);
    }

    public void setFirstName(String first) {
        IdentityManager identityManager = this.provider.getIdentityManager();
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)this.delegate.getUsername());
            if (picketlinkUser == null) {
                throw new IllegalStateException("User not found in LDAP storage!");
            }
            picketlinkUser.setFirstName(first);
            identityManager.update((AttributedType)picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw new ModelException((Throwable)ie);
        }
        this.delegate.setFirstName(first);
    }

    public void updateCredential(UserCredentialModel cred) {
        if (!this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            this.delegate.updateCredential(cred);
            return;
        }
        IdentityManager identityManager = this.provider.getIdentityManager();
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)this.getUsername());
            if (picketlinkUser == null) {
                logger.debugf("User '%s' doesn't exists. Skip password update", (Object)this.getUsername());
                throw new IllegalStateException("User doesn't exist in LDAP storage");
            }
            if (cred.getType().equals("password")) {
                identityManager.updateCredential((Account)picketlinkUser, (Object)new Password(cred.getValue().toCharArray()));
            } else if (cred.getType().equals("totp")) {
                TOTPCredential credential = new TOTPCredential(cred.getValue());
                credential.setDevice(cred.getDevice());
                identityManager.updateCredential((Account)picketlinkUser, (Object)credential);
            }
        }
        catch (IdentityManagementException ie) {
            throw new ModelException((Throwable)ie);
        }
    }

    public void setEmail(String email) {
        IdentityManager identityManager = this.provider.getIdentityManager();
        try {
            User picketlinkUser = BasicModel.getUser((IdentityManager)identityManager, (String)this.delegate.getUsername());
            if (picketlinkUser == null) {
                throw new IllegalStateException("User not found in LDAP storage!");
            }
            picketlinkUser.setEmail(email);
            identityManager.update((AttributedType)picketlinkUser);
        }
        catch (IdentityManagementException ie) {
            throw new ModelException((Throwable)ie);
        }
        this.delegate.setEmail(email);
    }
}

