/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker.model;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.flows.Urls;

public class IdentityProviderBean {
    private boolean displaySocial;
    private List<IdentityProvider> providers;
    private RealmModel realm;

    public IdentityProviderBean(RealmModel realm, URI baseURI, UriInfo uriInfo) {
        this.realm = realm;
        List identityProviders = realm.getIdentityProviders();
        if (!identityProviders.isEmpty()) {
            this.providers = new LinkedList<IdentityProvider>();
            for (IdentityProviderModel identityProvider : identityProviders) {
                if (!identityProvider.isEnabled()) continue;
                this.addIdentityProvider(realm, baseURI, identityProvider);
            }
            if (!this.providers.isEmpty()) {
                this.displaySocial = true;
            }
        }
    }

    private void addIdentityProvider(RealmModel realm, URI baseURI, IdentityProviderModel identityProvider) {
        String loginUrl = Urls.identityProviderAuthnRequest((URI)baseURI, (String)identityProvider.getAlias(), (String)realm.getName()).toString();
        this.providers.add(new IdentityProvider(identityProvider.getAlias(), identityProvider.getProviderId(), loginUrl));
    }

    public List<IdentityProvider> getProviders() {
        return this.providers;
    }

    public boolean isDisplayInfo() {
        return this.realm.isRegistrationAllowed() || this.displaySocial;
    }

    public static class IdentityProvider {
        private final String alias;
        private final String providerId;
        private final String loginUrl;

        public IdentityProvider(String alias, String providerId, String loginUrl) {
            this.alias = alias;
            this.providerId = providerId;
            this.loginUrl = loginUrl;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }

        public String getProviderId() {
            return this.providerId;
        }
    }
}

