/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker.model;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;

public class OAuthGrantBean {
    private final String accessRequestMessage;
    private List<RoleModel> realmRolesRequested;
    private MultivaluedMap<String, RoleModel> resourceRolesRequested;
    private String code;
    private ClientModel client;
    private List<String> claimsRequested;

    public OAuthGrantBean(String code, ClientSessionModel clientSession, ClientModel client, List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested, String accessRequestMessage) {
        this.code = code;
        this.client = client;
        this.realmRolesRequested = realmRolesRequested;
        this.resourceRolesRequested = resourceRolesRequested;
        this.accessRequestMessage = accessRequestMessage;
        LinkedList<String> claims = new LinkedList<String>();
        if (clientSession != null) {
            for (ProtocolMapperModel model : client.getProtocolMappers()) {
                if (!model.isConsentRequired() || !model.getProtocol().equals(clientSession.getAuthMethod()) || model.getConsentText() == null) continue;
                claims.add(model.getConsentText());
            }
        }
        if (claims.size() > 0) {
            this.claimsRequested = claims;
        }
    }

    public String getCode() {
        return this.code;
    }

    public MultivaluedMap<String, RoleModel> getResourceRolesRequested() {
        return this.resourceRolesRequested;
    }

    public List<RoleModel> getRealmRolesRequested() {
        return this.realmRolesRequested;
    }

    public String getClient() {
        return this.client.getClientId();
    }

    public List<String> getClaimsRequested() {
        return this.claimsRequested;
    }

    public String getAccessRequestMessage() {
        return this.accessRequestMessage;
    }
}

